/*
 * Decompiled with CFR 0.152.
 */
package adams.data.report;

import adams.core.CloneHandler;
import adams.data.report.DataType;
import adams.data.report.Field;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractField
implements Serializable,
Comparable,
CloneHandler<AbstractField> {
    private static final long serialVersionUID = -5720659277852926115L;
    public static final String SEPARATOR = "\t";
    public static final String SEPARATOR_ESCAPED = "\\t";
    public static final String SEPARATOR_DISPLAY = " | ";
    protected String m_Name;
    protected String m_Prefix;
    protected String m_Suffix;
    protected DataType m_DataType;

    public AbstractField() {
        this(null, DataType.UNKNOWN);
    }

    public AbstractField(AbstractField field) {
        this(field.getName(), field.getDataType());
    }

    public AbstractField(String name, DataType dt) {
        if (name != null) {
            this.m_Name = AbstractField.fixString(AbstractField.unescape(name));
        }
        this.m_DataType = dt == null ? DataType.UNKNOWN : dt;
        this.m_Prefix = null;
        this.m_Suffix = null;
    }

    public String getName() {
        return this.m_Name;
    }

    public DataType getDataType() {
        return this.m_DataType;
    }

    public boolean isCompound() {
        if (this.m_Name == null || this.m_Name.length() == 0) {
            return false;
        }
        return this.m_Name.indexOf(SEPARATOR) > -1;
    }

    public String[] split() {
        if (this.m_Name == null) {
            return new String[0];
        }
        return this.m_Name.split(SEPARATOR);
    }

    public String toParseableString() {
        if (this.m_Name == null) {
            return "";
        }
        return AbstractField.escape(this.m_Name, SEPARATOR_ESCAPED) + "[" + this.getDataType() + "]";
    }

    public String toString() {
        if (this.m_Name == null) {
            return "";
        }
        return AbstractField.escape(this.m_Name, SEPARATOR_ESCAPED);
    }

    public String toDisplayString() {
        if (this.m_Name == null) {
            return "";
        }
        return AbstractField.escape(this.m_Name, SEPARATOR_DISPLAY);
    }

    public String toString(Object o) {
        return o.toString();
    }

    public Object valueOf(String s) {
        Object result = null;
        try {
            switch (this.m_DataType) {
                case STRING: {
                    result = AbstractField.fixString(s);
                    break;
                }
                case NUMERIC: {
                    result = Double.parseDouble(s);
                    break;
                }
                case BOOLEAN: {
                    result = Boolean.parseBoolean(s);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandlded type '" + this.m_DataType + "'!");
                }
            }
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    protected static String escape(String name, String separator) {
        String result = name;
        result = result.replace(SEPARATOR, separator);
        result = result.replace("[", "\\[");
        result = result.replace("]", "\\]");
        return result;
    }

    protected static String unescape(String name) {
        String result = name;
        result = result.replace(SEPARATOR_ESCAPED, SEPARATOR);
        result = result.replace("\\[", "[");
        result = result.replace("\\]", "]");
        return result;
    }

    public static AbstractField parseField(String s) {
        String typeStr;
        String name = s;
        DataType type = DataType.UNKNOWN;
        if (s.length() > 3 && s.endsWith("]") && (typeStr = s.substring(s.length() - 3)).startsWith("[") && typeStr.length() == 3) {
            typeStr = typeStr.substring(1, 2);
            for (DataType t : DataType.values()) {
                if (!t.toDisplay().equals(typeStr)) continue;
                type = t;
                name = s.substring(0, s.length() - 3);
                break;
            }
        }
        Field result = new Field(AbstractField.unescape(name), type);
        return result;
    }

    @Override
    public AbstractField getClone() {
        return this.newField(this.m_Name, this.m_DataType);
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        if (!(o instanceof AbstractField)) {
            return -1;
        }
        AbstractField f = (AbstractField)o;
        if (this.getName() == null && f.getName() == null) {
            return 0;
        }
        if (this.getName() == null) {
            return -1;
        }
        if (f.getName() == null) {
            return 1;
        }
        return this.getName().toLowerCase().compareTo(f.getName().toLowerCase());
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public int hashCode() {
        if (this.m_Name == null) {
            return -1;
        }
        return this.getName().hashCode();
    }

    public String getPrefix() {
        if (!this.isCompound()) {
            return null;
        }
        if (this.m_Prefix == null) {
            this.m_Prefix = this.split()[0];
        }
        return this.m_Prefix;
    }

    public String getSuffix() {
        if (!this.isCompound()) {
            return null;
        }
        if (this.m_Suffix == null) {
            this.m_Suffix = this.split()[1];
        }
        return this.m_Suffix;
    }

    protected abstract AbstractField newField(String var1, DataType var2);

    public abstract AbstractField replacePrefix(String var1);

    public abstract AbstractField replaceSuffix(String var1);

    public static String fixString(String s) {
        return s.replace('\'', '`');
    }
}

