/*
 * Decompiled with CFR 0.152.
 */
package adams.data.statistics;

import adams.data.statistics.AbstractArrayStatistic;
import adams.data.statistics.EqualLengthArrayStatistic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayDifference<T extends Number>
extends AbstractArrayStatistic<T>
implements EqualLengthArrayStatistic {
    private static final long serialVersionUID = -5911270089583842477L;
    protected boolean m_AbsoluteValue;

    @Override
    public String globalInfo() {
        return "Calculates the difference between the arrays.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("absolute", "absoluteValue", false);
    }

    public void setAbsoluteValue(boolean value) {
        this.m_AbsoluteValue = value;
        this.reset();
    }

    public boolean getAbsoluteValue() {
        return this.m_AbsoluteValue;
    }

    public String absoluteValueTipText() {
        return "If set to true, then the absolute difference is returned instead.";
    }

    @Override
    public int getLength() {
        if (this.size() > 0) {
            return ((Number[])this.get(0)).length;
        }
        return -1;
    }

    @Override
    public int getMin() {
        return 2;
    }

    @Override
    public int getMax() {
        return -1;
    }

    @Override
    protected AbstractArrayStatistic.StatisticContainer doCalculate() {
        AbstractArrayStatistic.StatisticContainer<Double> result = new AbstractArrayStatistic.StatisticContainer<Double>(this.getLength(), this.size() - 1);
        String prefix = "difference";
        if (this.size() > 2) {
            prefix = prefix + "-";
        }
        for (int i = 1; i < this.size(); ++i) {
            if (this.size() > 2) {
                result.setHeader(i - 1, prefix + "1-" + (i + 1));
            } else {
                result.setHeader(i - 1, prefix);
            }
            for (int n = 0; n < this.getLength(); ++n) {
                double diff = ((Number[])this.get(0))[n].doubleValue() - ((Number[])this.get(i))[n].doubleValue();
                if (this.m_AbsoluteValue) {
                    diff = Math.abs(diff);
                }
                result.setCell(n, i - 1, diff);
            }
        }
        return result;
    }
}

