/*
 * Decompiled with CFR 0.152.
 */
package adams.data.statistics;

import adams.data.statistics.AbstractArrayStatistic;
import adams.data.statistics.Percentile;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayPercentile<T extends Number>
extends AbstractArrayStatistic<T> {
    private static final long serialVersionUID = 8011213325443103860L;
    protected double m_Percentile;

    @Override
    public String globalInfo() {
        return "Determines the percentile for an array.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("percentile", "percentile", 0.75, 1.0E-5, 0.99999);
    }

    public void setPercentile(double value) {
        this.m_Percentile = value;
        this.reset();
    }

    public double getPercentile() {
        return this.m_Percentile;
    }

    public String percentileTipText() {
        return "The percentile to calculate (0.0-1.0); eg, use 0.75 for the 75th percentile.";
    }

    @Override
    public int getMin() {
        return 1;
    }

    @Override
    public int getMax() {
        return -1;
    }

    @Override
    protected AbstractArrayStatistic.StatisticContainer doCalculate() {
        AbstractArrayStatistic.StatisticContainer<Serializable> result = new AbstractArrayStatistic.StatisticContainer<Serializable>(1, this.size());
        String prefix = "percentile-" + this.m_Percentile;
        if (this.size() > 1) {
            prefix = prefix + "-";
        }
        Percentile<Double> perc = new Percentile<Double>();
        for (int i = 0; i < this.size(); ++i) {
            if (this.size() > 1) {
                result.setHeader(i, prefix + (i + 1));
            } else {
                result.setHeader(i, prefix);
            }
            perc.clear();
            for (int n = 0; n < ((Number[])this.get(i)).length; ++n) {
                perc.add(((Number[])this.get(i))[n].doubleValue());
            }
            result.setCell(0, i, (Serializable)perc.getPercentile(this.m_Percentile));
        }
        return result;
    }
}

