/*
 * Decompiled with CFR 0.152.
 */
package adams.db;

import adams.core.ClassLister;
import adams.db.AbstractDatabaseConnection;
import adams.db.SQL;
import adams.event.DatabaseConnectionChangeEvent;
import adams.event.DatabaseConnectionChangeListener;

public abstract class AbstractTable
extends SQL
implements DatabaseConnectionChangeListener {
    private static final long serialVersionUID = 4511302757992864994L;
    protected String m_TableName;

    public AbstractTable(AbstractDatabaseConnection dbcon, String tableName) {
        super(dbcon);
        this.m_TableName = tableName;
        this.m_DatabaseConnection.addChangeListener(this);
    }

    public String getTableName() {
        return this.m_TableName;
    }

    protected boolean tableExists() {
        return this.tableExists(this.getTableName());
    }

    public abstract boolean init();

    public void databaseConnectionStateChanged(DatabaseConnectionChangeEvent e) {
    }

    public String toString() {
        return this.getTableName() + ": " + this.getDatabaseConnection().toString();
    }

    public static String[] getTables() {
        return ClassLister.getSingleton().getClassnames(AbstractTable.class);
    }
}

