/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.ifthenelse;

import adams.core.io.PlaceholderDirectory;
import adams.flow.condition.ifthenelse.AbstractIfThenElseCondition;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.core.Unknown;

public class DirectoryExists
extends AbstractIfThenElseCondition {
    private static final long serialVersionUID = 912094591109587908L;
    protected PlaceholderDirectory m_Directory;

    public String globalInfo() {
        return "Emulates an If-Then-Else construct. The 'Then' branch gets executed if the directory exists, otherwise the 'Else' branch.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("directory", "directory", new PlaceholderDirectory("."));
    }

    public void setDirectory(PlaceholderDirectory value) {
        this.m_Directory = value;
        this.reset();
    }

    public PlaceholderDirectory getDirectory() {
        return this.m_Directory;
    }

    public String directoryTipText() {
        return "The directory to look for.";
    }

    public String getQuickInfo() {
        String result = "dir: ";
        String variable = this.getOptionManager().getVariableForProperty("directory");
        result = variable != null ? result + variable : result + this.m_Directory.toString();
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    public String setUp() {
        String result = null;
        if (this.m_Directory == null) {
            result = "No directory provided!";
        }
        return result;
    }

    public boolean doThen(AbstractActor owner, Token token) {
        return this.m_Directory.exists() && this.m_Directory.isDirectory();
    }
}

