/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.io.PlaceholderFile;
import adams.flow.core.AbstractActor;

public abstract class AbstractScriptActor
extends AbstractActor {
    private static final long serialVersionUID = -8187233244973711251L;
    protected PlaceholderFile m_ScriptFile;
    protected String m_ScriptOptions;
    protected transient Object m_ScriptObject;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("script", "scriptFile", new PlaceholderFile("."));
        this.m_OptionManager.add("options", "scriptOptions", "");
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("scriptFile");
        if (variable != null) {
            return variable;
        }
        return new String(this.m_ScriptFile + " " + this.m_ScriptOptions).trim();
    }

    public void setScriptFile(PlaceholderFile value) {
        this.m_ScriptFile = value;
        this.reset();
    }

    public PlaceholderFile getScriptFile() {
        return this.m_ScriptFile;
    }

    public String scriptFileTipText() {
        return "The script file to load and execute.";
    }

    public void setScriptOptions(String value) {
        this.m_ScriptOptions = value;
        this.reset();
    }

    public String getScriptOptions() {
        return this.m_ScriptOptions;
    }

    public String scriptOptionsTipText() {
        return "The options for the script.";
    }

    protected abstract String loadScriptObject();

    protected abstract String checkScriptObject();

    protected String initScriptObject() {
        String result = this.loadScriptObject();
        if (result == null) {
            result = this.checkScriptObject();
        }
        return result;
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            result = this.initScriptObject();
        }
        return result;
    }

    public void wrapUp() {
        super.wrapUp();
        this.m_ScriptObject = null;
    }
}

