/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.data.statistics.InformativeStatistic;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActorStatistic
implements InformativeStatistic {
    public static String COUNT_ACTORS = "Actors";
    public static String COUNT_CONTROLACTORS = "Control actors";
    public static String COUNT_STANDALONES = "Standalones";
    public static String COUNT_SOURCES = "Sources";
    public static String COUNT_TRANSFORMERS = "Transformers";
    public static String COUNT_SINKS = "Sinks";
    protected Hashtable<String, Integer> m_Statistics = new Hashtable();
    protected AbstractActor m_Actor = null;

    public ActorStatistic() {
    }

    public ActorStatistic(AbstractActor actor) {
        this();
        this.setActor(actor);
    }

    public void setActor(AbstractActor value) {
        this.m_Actor = value;
        this.calculate();
    }

    public AbstractActor getActor() {
        return this.m_Actor;
    }

    protected void update(AbstractActor actor) {
        this.m_Statistics.put(COUNT_ACTORS, this.m_Statistics.get(COUNT_ACTORS) + 1);
        if (ActorUtils.isControlActor(actor)) {
            this.m_Statistics.put(COUNT_CONTROLACTORS, this.m_Statistics.get(COUNT_CONTROLACTORS) + 1);
        }
        if (ActorUtils.isStandalone(actor)) {
            this.m_Statistics.put(COUNT_STANDALONES, this.m_Statistics.get(COUNT_STANDALONES) + 1);
        }
        if (ActorUtils.isSource(actor)) {
            this.m_Statistics.put(COUNT_SOURCES, this.m_Statistics.get(COUNT_SOURCES) + 1);
        }
        if (ActorUtils.isTransformer(actor)) {
            this.m_Statistics.put(COUNT_TRANSFORMERS, this.m_Statistics.get(COUNT_TRANSFORMERS) + 1);
        }
        if (ActorUtils.isSink(actor)) {
            this.m_Statistics.put(COUNT_SINKS, this.m_Statistics.get(COUNT_SINKS) + 1);
        }
    }

    protected void calculate() {
        this.m_Statistics.clear();
        this.m_Statistics.put(COUNT_ACTORS, 0);
        this.m_Statistics.put(COUNT_CONTROLACTORS, 0);
        this.m_Statistics.put(COUNT_STANDALONES, 0);
        this.m_Statistics.put(COUNT_SOURCES, 0);
        this.m_Statistics.put(COUNT_TRANSFORMERS, 0);
        this.m_Statistics.put(COUNT_SINKS, 0);
        if (this.m_Actor == null) {
            return;
        }
        Vector<AbstractActor> actors = ActorUtils.enumerate(this.getActor());
        this.update(this.m_Actor);
        for (AbstractActor actor : actors) {
            this.update(actor);
        }
    }

    @Override
    public String getStatisticDescription() {
        if (this.m_Actor == null) {
            return "Statistics";
        }
        return this.m_Actor.getName();
    }

    @Override
    public Enumeration<String> statisticNames() {
        Vector<String> result = new Vector<String>(this.m_Statistics.keySet());
        Collections.sort(result);
        return result.elements();
    }

    @Override
    public double getStatistic(String name) {
        return this.m_Statistics.get(name).doubleValue();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getStatisticDescription());
        result.append("\n");
        Enumeration<String> names = this.statisticNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            result.append(name + ": " + this.getStatistic(name));
            result.append("\n");
        }
        return result.toString();
    }
}

