/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.data.report.Report;
import adams.data.report.ReportHandler;
import adams.flow.core.Token;
import adams.flow.sink.AbstractTextualDisplay;
import adams.gui.core.BasePanel;
import adams.gui.core.SearchPanel;
import adams.gui.event.SearchEvent;
import adams.gui.event.SearchListener;
import adams.gui.visualization.container.ContainerManager;
import adams.gui.visualization.report.ReportContainer;
import adams.gui.visualization.report.ReportContainerManager;
import adams.gui.visualization.report.ReportFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ReportDisplay
extends AbstractTextualDisplay {
    private static final long serialVersionUID = 934663436062863370L;
    protected ReportFactory.Panel m_Panel;
    protected SearchPanel m_SearchPanel;
    protected boolean m_ReportSelected;

    public String globalInfo() {
        return "Displays reports.";
    }

    protected int getDefaultWidth() {
        return 450;
    }

    protected int getDefaultHeight() {
        return 600;
    }

    public void clearPanel() {
        ((ContainerManager)this.m_Panel.getContainerManager()).clear();
        this.m_ReportSelected = false;
    }

    protected BasePanel newPanel() {
        this.m_Panel = ReportFactory.getPanel(new Vector<ReportContainer>());
        this.m_Panel.setDividerLocation((int)((double)this.getWidth() * 0.67));
        BasePanel result = new BasePanel(new BorderLayout());
        result.add((Component)this.m_Panel, "Center");
        JPanel panel = new JPanel(new FlowLayout(0));
        this.m_SearchPanel = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, true);
        this.m_SearchPanel.addSearchListener(new SearchListener(){

            public void searchInitiated(SearchEvent e) {
                ReportDisplay.this.m_Panel.search(ReportDisplay.this.m_SearchPanel.getSearchText(), ReportDisplay.this.m_SearchPanel.isRegularExpression());
                ReportDisplay.this.m_SearchPanel.grabFocus();
            }
        });
        panel.add(this.m_SearchPanel);
        result.add((Component)panel, "South");
        this.m_ReportSelected = false;
        return result;
    }

    protected String createTitle() {
        return "Report - " + this.getFullName();
    }

    public Class[] accepts() {
        return new Class[]{ReportHandler.class, Report.class};
    }

    protected void display(Token token) {
        Report report = token.getPayload() instanceof ReportHandler ? ((ReportHandler)token.getPayload()).getReport() : (Report)token.getPayload();
        if (report != null) {
            ((ContainerManager)this.m_Panel.getContainerManager()).add((ReportContainer)((ReportContainerManager)this.m_Panel.getContainerManager()).newContainer(report));
        }
    }

    protected void postDisplay(Token token) {
        super.postDisplay(token);
        if (!this.m_ReportSelected) {
            Runnable runnable = new Runnable(){

                public void run() {
                    if (((ContainerManager)ReportDisplay.this.m_Panel.getContainerManager()).count() > 0) {
                        ReportDisplay.this.m_Panel.setCurrentTable(0);
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    protected boolean supportsClear() {
        return true;
    }

    protected void clear() {
        ((ContainerManager)this.m_Panel.getContainerManager()).clear();
    }

    public String supplyText() {
        Report report;
        String result = null;
        int index = this.m_Panel.getSelectedRow();
        if (index != -1 && (report = ((ReportContainer)this.m_Panel.getData().get(index)).getReport()) != null) {
            result = report.toProperties().toString();
        }
        return result;
    }
}

