/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.VariableName;
import adams.flow.core.Token;
import adams.flow.source.AbstractSource;

public class Variable
extends AbstractSource {
    private static final long serialVersionUID = -7838881435448178095L;
    protected VariableName m_VariableName;
    protected String m_VariableValue;

    public String globalInfo() {
        return "Outputs the string value of the specified variable.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("var-name", "variableName", new VariableName());
    }

    public void setVariableName(VariableName value) {
        this.m_VariableName = value;
        this.reset();
    }

    public VariableName getVariableName() {
        return this.m_VariableName;
    }

    public String variableNameTipText() {
        return "The name of the variable to update.";
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("variableName");
        if (variable != null) {
            return variable;
        }
        return this.m_VariableName.paddedValue();
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    protected void reset() {
        super.reset();
        this.m_VariableValue = null;
    }

    protected String doExecute() {
        String result = null;
        if (this.getVariables().has(this.m_VariableName.getValue())) {
            this.m_VariableValue = this.getVariables().get(this.m_VariableName.getValue());
        } else {
            result = "Variable '" + this.m_VariableName + "' is not set!";
        }
        return result;
    }

    public Token output() {
        Token result = new Token(this.m_VariableValue);
        this.m_VariableValue = null;
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_VariableValue != null;
    }
}

