/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.base.BaseRegExp;
import adams.db.AbstractDatabaseConnection;
import adams.flow.standalone.AbstractStandalone;

public abstract class AbstractDatabaseCheck
extends AbstractStandalone {
    private static final long serialVersionUID = -1726172998200420556L;
    protected BaseRegExp m_RegExp;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("regexp", "regExp", new BaseRegExp(".*"));
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("regExp");
        if (variable != null) {
            return variable;
        }
        return this.m_RegExp.getValue();
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression to match the JDBC URL against";
    }

    protected abstract AbstractDatabaseConnection getDatabaseConnection();

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            AbstractDatabaseConnection conn = this.getDatabaseConnection();
            if (!conn.isConnected()) {
                result = "No connection to database!";
            } else {
                String url = conn.getURL();
                if (!this.m_RegExp.isMatch(url)) {
                    result = "Database URL '" + url + "' does not match regular expression '" + this.m_RegExp + "'!";
                }
            }
        }
        return result;
    }

    protected String doExecute() {
        return null;
    }
}

