/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.template;

import adams.core.Utils;
import adams.core.base.BaseRegExp;
import adams.core.base.BaseString;
import adams.core.io.FileUtils;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.NestedConsumer;
import adams.flow.core.AbstractActor;
import adams.flow.template.FromFile;
import java.util.Vector;

public class StringReplace
extends FromFile {
    private static final long serialVersionUID = -8975800423604842422L;
    protected BaseRegExp[] m_Find;
    protected BaseString[] m_Replace;

    public String globalInfo() {
        return "Replaces strings that match the specified regular expressions in the file before instantiating an actor from it.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("find", "find", new BaseRegExp[0]);
        this.m_OptionManager.add("replace", "replace", new BaseString[0]);
    }

    public void setFind(BaseRegExp[] value) {
        this.m_Find = value;
        this.reset();
    }

    public BaseRegExp[] getFind() {
        return this.m_Find;
    }

    public String findTipText() {
        return "The regular expressions to use for matching.";
    }

    public void setReplace(BaseString[] value) {
        this.m_Replace = value;
        this.reset();
    }

    public BaseString[] getReplace() {
        return this.m_Replace;
    }

    public String replaceTipText() {
        return "The strings to replace the matching strings with.";
    }

    protected void preGenerate() {
        super.preGenerate();
        if (this.m_Find.length != this.m_Replace.length) {
            throw new IllegalStateException("'find' and 'replace' have different amounts of elements: " + this.m_Find.length + " != " + this.m_Replace.length);
        }
        if (this.m_Find.length == 0) {
            this.getSystemErr().println("Warning: no find/replace defined");
        }
    }

    protected AbstractActor doGenerate() {
        AbstractActor result = null;
        Vector<String> lines = FileUtils.loadFromFile(this.m_TemplateFile);
        if (lines != null) {
            for (int i = 0; i < lines.size(); ++i) {
                String line = lines.get(i);
                if (line.length() <= 0) continue;
                for (int n = 0; n < this.m_Find.length; ++n) {
                    String find = this.m_Find[n].stringValue();
                    String replace = this.m_Replace[n].stringValue();
                    line = line.replaceAll(find, replace);
                }
                lines.set(i, line);
            }
            result = (AbstractActor)AbstractOptionConsumer.fromString(NestedConsumer.class, Utils.flatten(lines, "\n"));
            if (result == null) {
                this.getSystemErr().println("Failed to instantiate actor from: " + this.m_TemplateFile);
            }
        } else {
            this.getSystemErr().println("Failed to read content from: " + this.m_TemplateFile);
        }
        return result;
    }
}

