/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.data.container.DataContainer;
import adams.data.filter.PassThrough;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnectionHandler;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractDataContainerTransformer;

public abstract class AbstractFilter
extends AbstractDataContainerTransformer
implements ProvenanceSupporter {
    private static final long serialVersionUID = 4527040722924866539L;
    protected adams.data.filter.AbstractFilter m_Filter;

    public String globalInfo() {
        return "Filters data using the specified filter.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("filter", "filter", new PassThrough());
    }

    public void setFilter(adams.data.filter.AbstractFilter value) {
        this.m_Filter = value;
        this.reset();
    }

    public adams.data.filter.AbstractFilter getFilter() {
        return this.m_Filter;
    }

    public String filterTipText() {
        return "The filter to use for filtering the data.";
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("filter");
        if (variable != null) {
            return variable;
        }
        if (this.m_Filter != null) {
            return this.m_Filter.getClass().getName();
        }
        return null;
    }

    protected abstract Class getDataContainerClass();

    protected abstract AbstractDatabaseConnection getDatabaseConnection();

    public String setUp() {
        String result = super.setUp();
        if (result == null && this.m_Filter instanceof DatabaseConnectionHandler) {
            ((DatabaseConnectionHandler)((Object)this.m_Filter)).setDatabaseConnection(this.getDatabaseConnection());
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        DataContainer chr = this.m_Filter.filter((DataContainer)this.m_InputToken.getPayload());
        if (chr == null) {
            result = "No data obtained from filter: " + this.m_InputToken;
        } else {
            this.m_OutputToken = new Token(chr);
        }
        if (this.m_OutputToken != null) {
            this.updateProvenance(this.m_OutputToken);
        }
        this.m_Filter.cleanUp();
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            cont.setProvenance(this.m_InputToken.getProvenance());
            cont.addProvenance(new ProvenanceInformation(ActorType.PREPROCESSOR, this.m_InputToken.getPayload().getClass(), this, this.m_OutputToken.getPayload().getClass()));
        }
    }
}

