/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.flow.core.AbstractExternalActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.InputConsumer;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalTransformer
extends AbstractExternalActor
implements InputConsumer,
OutputProducer {
    private static final long serialVersionUID = 8557732787822426844L;
    public static final String BACKUP_INPUT = "input";
    protected transient Token m_InputToken;

    @Override
    public String globalInfo() {
        return "Transformer that executes an external transformer actor stored on disk.";
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        if (this.m_InputToken != null) {
            result.put(BACKUP_INPUT, this.m_InputToken);
        }
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_INPUT)) {
            this.m_InputToken = (Token)state.get(BACKUP_INPUT);
            state.remove(BACKUP_INPUT);
        }
        super.restoreState(state);
    }

    @Override
    protected String setUpExternalActor() {
        String result = super.setUpExternalActor();
        if (result == null && !ActorUtils.isTransformer(this.m_ExternalActor)) {
            result = "External actor '" + this.m_ActorFile.getAbsolutePath() + "' is not a transformer!";
        }
        return result;
    }

    @Override
    public Class[] accepts() {
        if (this.m_ExternalActor != null) {
            return ((InputConsumer)((Object)this.m_ExternalActor)).accepts();
        }
        return new Class[]{Unknown.class};
    }

    @Override
    public void input(Token token) {
        this.m_InputToken = token;
    }

    @Override
    public Class[] generates() {
        if (this.m_ExternalActor != null) {
            return ((OutputProducer)((Object)this.m_ExternalActor)).generates();
        }
        return new Class[]{Unknown.class};
    }

    @Override
    protected String preExecuteExternalActorHook() {
        ((InputConsumer)((Object)this.m_ExternalActor)).input(this.m_InputToken);
        this.m_InputToken = null;
        return null;
    }

    @Override
    public Token output() {
        return ((OutputProducer)((Object)this.m_ExternalActor)).output();
    }

    @Override
    public boolean hasPendingOutput() {
        return ((OutputProducer)((Object)this.m_ExternalActor)).hasPendingOutput();
    }
}

