/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.flow.container.SequencePlotterContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;

public class MakePlotContainer
extends AbstractTransformer {
    private static final long serialVersionUID = 2488434486963278287L;
    protected String m_PlotName;
    protected boolean m_IsMarker;

    public String globalInfo() {
        return "Creates a named container for the SequencePlotter actor.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("plot-name", "plotName", "Plot");
        this.m_OptionManager.add("is-marker", "isMarker", false);
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("plotName");
        String result = variable != null ? variable : (this.m_PlotName != null && this.m_PlotName.length() > 0 ? this.m_PlotName : "-unnamed-");
        if (this.m_IsMarker) {
            result = result + " (marker)";
        }
        return result;
    }

    public void setPlotName(String value) {
        this.m_PlotName = value;
        this.reset();
    }

    public String getPlotName() {
        return this.m_PlotName;
    }

    public String plotNameTipText() {
        return "The name for the plot.";
    }

    public void setIsMarker(boolean value) {
        this.m_IsMarker = value;
        this.reset();
    }

    public boolean getIsMarker() {
        return this.m_IsMarker;
    }

    public String isMarkerTipText() {
        return "If enabled, a container for a marker is created.";
    }

    public Class[] accepts() {
        return new Class[]{Double.class, Double[].class, Integer.class, Integer[].class};
    }

    protected String doExecute() {
        String result = null;
        SequencePlotterContainer cont = null;
        if (this.m_InputToken.getPayload() instanceof Double) {
            cont = new SequencePlotterContainer(this.m_PlotName, (Double)this.m_InputToken.getPayload(), this.m_IsMarker);
        } else if (this.m_InputToken.getPayload() instanceof Double[]) {
            if (((Double[])this.m_InputToken.getPayload()).length == 2) {
                cont = new SequencePlotterContainer(this.m_PlotName, ((Double[])this.m_InputToken.getPayload())[0], ((Double[])this.m_InputToken.getPayload())[1], this.m_IsMarker);
            } else {
                result = "Double array must have length 2 (provided: " + ((Double[])this.m_InputToken.getPayload()).length + ")!";
            }
        } else if (this.m_InputToken.getPayload() instanceof Integer) {
            cont = new SequencePlotterContainer(this.m_PlotName, (Double)((Integer)this.m_InputToken.getPayload()).doubleValue(), this.m_IsMarker);
        } else if (this.m_InputToken.getPayload() instanceof Integer[]) {
            if (((Integer[])this.m_InputToken.getPayload()).length == 2) {
                cont = new SequencePlotterContainer(this.m_PlotName, ((Integer[])this.m_InputToken.getPayload())[0].doubleValue(), ((Integer[])this.m_InputToken.getPayload())[1].doubleValue(), this.m_IsMarker);
            } else {
                result = "Double array must have length 2 (provided: " + ((Double[])this.m_InputToken.getPayload()).length + ")!";
            }
        }
        if (cont != null) {
            this.m_OutputToken = new Token(cont);
        }
        return result;
    }

    public Class[] generates() {
        return new Class[]{SequencePlotterContainer.class};
    }
}

