/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.application;

import adams.core.ClassLocator;
import adams.core.CleanUpHandler;
import adams.core.PrintObject;
import adams.db.DatabaseConnectionHandler;
import adams.gui.application.AbstractApplicationFrame;
import adams.gui.application.Child;
import adams.gui.core.BaseWindow;
import adams.gui.core.GUIHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class ChildWindow
extends BaseWindow
implements Child {
    protected static final long serialVersionUID = 8588293938686425618L;
    protected AbstractApplicationFrame m_Parent;
    protected ChildWindow m_Self = this;
    protected boolean m_DisposeCalled;
    protected String m_Title;
    protected String m_InitialTitle;
    protected String m_IconName;
    protected boolean m_DisposeWindowListenerAdded;

    public ChildWindow(AbstractApplicationFrame parent, String title) {
        this(parent, title, null);
    }

    public ChildWindow(AbstractApplicationFrame parent, String title, String icon) {
        this.m_Parent = parent;
        this.m_Title = title;
        this.m_InitialTitle = title;
        this.m_DisposeWindowListenerAdded = false;
        this.m_IconName = icon;
        this.performInitialization();
    }

    protected void performInitialization() {
        if (this.getParentFrame() != null) {
            super.performInitialization();
        }
    }

    protected void initialize() {
        super.initialize();
        this.m_DisposeCalled = false;
    }

    protected void initGUI() {
        ImageIcon icon;
        super.initGUI();
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                if (ChildWindow.this.getParentFrame() != null) {
                    ChildWindow.this.getParentFrame().createTitle(ChildWindow.this.getTitle());
                }
            }

            public void windowClosing(WindowEvent e) {
                ChildWindow.this.cleanUp();
                if (!ChildWindow.this.m_DisposeCalled) {
                    ChildWindow.this.dispose();
                }
            }
        });
        if (this.getParentFrame() != null) {
            this.setIconImage(this.getParentFrame().getIconImage());
        }
        if (this.m_IconName != null && (icon = this.m_IconName.indexOf("/") > -1 ? GUIHelper.getExternalIcon(this.m_IconName) : GUIHelper.getIcon(this.m_IconName)) != null) {
            this.setIconImage(icon.getImage());
        }
        if (this.getParentFrame() != null) {
            this.getParentFrame().addChildWindow(this);
        }
    }

    public AbstractApplicationFrame getParentFrame() {
        return this.m_Parent;
    }

    public String getTitle() {
        return this.m_Title;
    }

    public void setTitle(String title) {
        this.m_Title = title;
        if (this.isActive()) {
            this.getParentFrame().createTitle(title);
        }
        this.getParentFrame().windowListChanged();
    }

    public void cleanUp() {
        Component comp = this.getContentPane().getComponent(0);
        if (comp instanceof CleanUpHandler) {
            ((CleanUpHandler)((Object)comp)).cleanUp();
        }
    }

    public void dispose() {
        this.m_DisposeCalled = true;
        if (this.getParentFrame() != null) {
            this.getParentFrame().removeChildFrame(this);
            this.getParentFrame().createTitle("");
        }
        super.dispose();
    }

    public boolean canCreateNewWindow() {
        Component comp = this.getContentPane().getComponent(0);
        boolean result = ClassLocator.isSubclass(JPanel.class, comp.getClass());
        if (result) {
            try {
                comp.getClass().getConstructor(new Class[0]);
            }
            catch (Exception e) {
                result = false;
            }
        }
        return result;
    }

    public ChildWindow getNewWindow() {
        ChildWindow result;
        if (!this.canCreateNewWindow()) {
            return null;
        }
        Component comp = this.getContentPane().getComponent(0);
        try {
            JPanel panel = (JPanel)comp.getClass().newInstance();
            result = new ChildWindow(this.getParentFrame(), this.m_InitialTitle, this.m_IconName);
            result.setSize(this.getSize());
            result.setLocation(this.getX() + 20, this.getY() + 20);
            result.getContentPane().setLayout(new BorderLayout());
            result.getContentPane().add((Component)panel, "Center");
            if (this.getParentFrame() instanceof DatabaseConnectionHandler && panel instanceof DatabaseConnectionHandler) {
                ((DatabaseConnectionHandler)((Object)panel)).setDatabaseConnection(this.getParentFrame().getDatabaseConnection());
            }
            if (this.m_DisposeWindowListenerAdded) {
                result.addDisposeWindowListener();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public void addDisposeWindowListener() {
        this.m_DisposeWindowListenerAdded = true;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ChildWindow.this.m_Self.dispose();
            }
        });
    }

    public PrintObject getDebugging() {
        return this.getParentFrame().getDebugging();
    }

    public PrintObject getSystemOut() {
        return this.getParentFrame().getSystemOut();
    }

    public PrintObject getSystemErr() {
        return this.getParentFrame().getSystemErr();
    }
}

