/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.core.io.PlaceholderFile;
import adams.data.io.input.AbstractReportReader;
import adams.data.io.output.AbstractReportWriter;
import adams.data.report.Report;
import adams.gui.chooser.AbstractExtensionFileFilterFileChooser;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.goe.GenericObjectEditor;
import adams.gui.goe.GenericObjectEditorDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReportFileChooser<T extends Report>
extends AbstractExtensionFileFilterFileChooser<ReportFileExtensionFilter> {
    private static final long serialVersionUID = -5373058011025481738L;
    protected static Hashtable<Class, Vector<ReportFileExtensionFilter>> m_ReaderFileFilters = new Hashtable();
    protected static Hashtable<Class, Vector<ReportFileExtensionFilter>> m_WriterFileFilters = new Hashtable();
    protected JButton m_ConfigureButton;
    protected JCheckBox m_CheckBoxOptions;
    protected JLabel m_LabelOptions;
    protected GenericObjectEditor m_Editor;

    protected AbstractReportFileChooser() {
    }

    protected AbstractReportFileChooser(File currentDirectory) {
        super(currentDirectory);
    }

    protected AbstractReportFileChooser(String currentDirectory) {
        super(currentDirectory);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_CheckBoxOptions = new JCheckBox("Invoke options dialog");
        this.m_CheckBoxOptions.setMnemonic('I');
        this.m_LabelOptions = new JLabel("<html><br>Note:<br><br>Some file formats offer additional<br>options which can be customized<br>when invoking the options dialog.</html>");
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.m_CheckBoxOptions, "North");
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)this.m_LabelOptions, "North");
        panel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add((Component)panel2, "Center");
        this.setAccessory(panel);
        this.m_Editor = new GenericObjectEditor(false);
    }

    protected static void initFilters(AbstractReportFileChooser chooser, boolean reader, String[] classnames) {
        if (reader) {
            m_ReaderFileFilters.put(chooser.getClass(), new Vector());
        } else {
            m_WriterFileFilters.put(chooser.getClass(), new Vector());
        }
        for (int i = 0; i < classnames.length; ++i) {
            ReportFileExtensionFilter filter;
            String[] ext;
            String desc;
            Object converter;
            Class<?> cls;
            String classname = classnames[i];
            try {
                cls = Class.forName(classname);
                converter = cls.newInstance();
                if (reader) {
                    desc = ((AbstractReportReader)converter).getFormatDescription();
                    ext = ((AbstractReportReader)converter).getFormatExtensions();
                } else {
                    desc = ((AbstractReportWriter)converter).getFormatDescription();
                    ext = ((AbstractReportWriter)converter).getFormatExtensions();
                }
            }
            catch (Exception e) {
                cls = null;
                converter = null;
                ext = new String[]{};
                desc = "";
            }
            if (converter == null) continue;
            if (reader) {
                filter = new ReportFileExtensionFilter(classname, desc, ext);
                m_ReaderFileFilters.get(chooser.getClass()).add(filter);
                continue;
            }
            filter = new ReportFileExtensionFilter(classname, desc, ext);
            m_WriterFileFilters.get(chooser.getClass()).add(filter);
        }
    }

    @Override
    protected Vector<ReportFileExtensionFilter> getOpenFileFilters() {
        return m_ReaderFileFilters.get(this.getClass());
    }

    @Override
    protected Vector<ReportFileExtensionFilter> getSaveFileFilters() {
        return m_WriterFileFilters.get(this.getClass());
    }

    @Override
    protected void initGUI(int dialogType) {
        super.initGUI(dialogType);
        if (dialogType == 1) {
            this.m_Editor.setClassType(AbstractReportReader.class);
            this.m_Editor.setValue(this.getDefaultReader());
        } else {
            this.m_Editor.setClassType(AbstractReportWriter.class);
            this.m_Editor.setValue(this.getDefaultWriter());
        }
    }

    protected abstract AbstractReportReader<T> getDefaultReader();

    protected abstract AbstractReportWriter<T> getDefaultWriter();

    @Override
    public int showOpenDialog(Component parent) {
        int result = super.showOpenDialog(parent);
        if (result == 0 && this.m_CheckBoxOptions.isSelected()) {
            this.m_Editor.setValue(this.m_CurrentHandler);
            GenericObjectEditorDialog dialog = GenericObjectEditorDialog.createDialog(this, this.m_Editor);
            dialog.setVisible(true);
            result = dialog.getResult();
            if (result == 0) {
                this.m_CurrentHandler = this.m_Editor.getValue();
            }
        }
        return result;
    }

    @Override
    public int showSaveDialog(Component parent) {
        int result = super.showSaveDialog(parent);
        if (result == 0 && this.m_CheckBoxOptions.isSelected()) {
            GenericObjectEditorDialog dialog = GenericObjectEditorDialog.createDialog(this, this.m_Editor);
            dialog.setVisible(true);
            result = dialog.getResult();
            if (result == 0) {
                this.m_CurrentHandler = this.m_Editor.getValue();
            }
        }
        return result;
    }

    public AbstractReportReader getReader() {
        this.configureCurrentHandlerHook(1);
        if (this.m_CurrentHandler instanceof AbstractReportWriter) {
            return null;
        }
        return (AbstractReportReader)this.m_CurrentHandler;
    }

    public AbstractReportWriter getWriter() {
        this.configureCurrentHandlerHook(2);
        if (this.m_CurrentHandler instanceof AbstractReportReader) {
            return null;
        }
        return (AbstractReportWriter)this.m_CurrentHandler;
    }

    @Override
    protected void updateCurrentHandlerHook() {
        try {
            String classname = ((ReportFileExtensionFilter)this.getFileFilter()).getClassname();
            Object newHandler = Class.forName(classname).newInstance();
            if (this.m_CurrentHandler == null) {
                this.m_CurrentHandler = newHandler;
            } else if (!this.m_CurrentHandler.getClass().equals(newHandler.getClass())) {
                this.m_CurrentHandler = newHandler;
            }
            this.setFileSelectionMode(0);
        }
        catch (Exception e) {
            this.m_CurrentHandler = null;
            e.printStackTrace();
        }
    }

    @Override
    protected void configureCurrentHandlerHook(int dialogType) {
        PlaceholderFile selFile = this.getSelectedPlaceholderFile();
        if (this.m_CurrentHandler == null) {
            String classname = ((ReportFileExtensionFilter)this.getFileFilter()).getClassname();
            try {
                this.m_CurrentHandler = Class.forName(classname).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.m_CurrentHandler = null;
            }
            if (this.m_CurrentHandler == null) {
                return;
            }
        }
        if (selFile.isDirectory()) {
            return;
        }
        try {
            PlaceholderFile currFile = this.m_CurrentHandler instanceof AbstractReportReader ? ((AbstractReportReader)this.m_CurrentHandler).getInput() : ((AbstractReportWriter)this.m_CurrentHandler).getOutput();
            if (currFile == null || !((File)currFile).getAbsolutePath().equals(selFile.getAbsolutePath())) {
                if (this.m_CurrentHandler instanceof AbstractReportReader) {
                    ((AbstractReportReader)this.m_CurrentHandler).setInput(selFile);
                } else {
                    ((AbstractReportWriter)this.m_CurrentHandler).setOutput(selFile);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected boolean getFiltersInitialized() {
        return m_ReaderFileFilters.containsKey(this.getClass());
    }

    public static class ReportFileExtensionFilter
    extends ExtensionFileFilter {
        private static final long serialVersionUID = -5589412775033677018L;
        protected String m_Classname;

        public ReportFileExtensionFilter(String classname) {
            this.m_Classname = classname;
        }

        public ReportFileExtensionFilter(String classname, String description, String extension) {
            super(description, extension);
            this.m_Classname = classname;
        }

        public ReportFileExtensionFilter(String classname, String description, String[] extensions) {
            super(description, extensions);
            this.m_Classname = classname;
        }

        public ReportFileExtensionFilter(String classname, String description, String extension, boolean caseSensitive) {
            super(description, extension, caseSensitive);
            this.m_Classname = classname;
        }

        public ReportFileExtensionFilter(String classname, String description, String[] extensions, boolean caseSensitive) {
            super(description, extensions, caseSensitive);
            this.m_Classname = classname;
        }

        public String getClassname() {
            return this.m_Classname;
        }
    }
}

