/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.FieldType;
import adams.data.report.FieldUtils;
import adams.gui.chooser.AbstractChooserPanel;
import adams.gui.selection.SelectFieldDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldChooserPanel
extends AbstractChooserPanel<AbstractField> {
    private static final long serialVersionUID = -7800388925398386462L;
    protected SelectFieldDialog m_Dialog;

    public FieldChooserPanel() {
        this((AbstractField)null);
    }

    public FieldChooserPanel(AbstractField field) {
        if (field != null) {
            this.setCurrent(field);
        }
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Dialog = this.getParentDialog() != null ? new SelectFieldDialog(this.getParentDialog()) : new SelectFieldDialog(this.getParentFrame());
    }

    @Override
    protected AbstractField doChoose() {
        if (this.hasValue()) {
            this.m_Dialog.setItem((AbstractField)this.getCurrent());
        }
        this.m_Dialog.setLocationRelativeTo(this);
        this.m_Dialog.setVisible(true);
        if (this.m_Dialog.getOption() == 0) {
            return this.m_Dialog.getItem();
        }
        return null;
    }

    @Override
    protected String toString(AbstractField value) {
        return value.toString();
    }

    @Override
    protected AbstractField fromString(String value) {
        return FieldUtils.fixClass(this.getFieldType(), new Field(value, DataType.UNKNOWN));
    }

    public void setFieldType(FieldType value) {
        this.setCurrent(null);
        this.m_Dialog.setFieldType(value);
    }

    public FieldType getFieldType() {
        return this.m_Dialog.getFieldType();
    }
}

