/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.SizeSequence;

public class BaseSizeSequence
extends SizeSequence
implements Serializable {
    private static final long serialVersionUID = 4086903170875698686L;
    protected ArrayList<Integer> m_Sizes;
    protected ArrayList<Integer> m_Positions;

    public BaseSizeSequence() {
        this.m_Sizes = new ArrayList();
        this.m_Positions = new ArrayList();
    }

    public BaseSizeSequence(int numEntries) {
        this(numEntries, 0);
    }

    public BaseSizeSequence(int numEntries, int value) {
        this.m_Sizes = new ArrayList(numEntries);
        this.m_Positions = new ArrayList(numEntries);
        for (int i = 0; i < numEntries; ++i) {
            this.m_Sizes.add(value);
            this.m_Positions.add(value);
        }
        this.updatePositions(0);
    }

    public BaseSizeSequence(int[] sizes) {
        this();
        this.setSizes(sizes);
    }

    public void setSizes(int[] sizes) {
        this.m_Sizes = new ArrayList(sizes.length);
        this.m_Positions = new ArrayList(sizes.length);
        for (int i = 0; i < sizes.length; ++i) {
            this.m_Sizes.add(sizes[i]);
        }
        this.updatePositions(0);
    }

    public int[] getSizes() {
        int[] result = new int[this.m_Sizes.size()];
        for (int i = 0; i < this.m_Sizes.size(); ++i) {
            result[i] = this.m_Sizes.get(i);
        }
        return result;
    }

    public int getPosition(int index) {
        return this.m_Positions.get(index);
    }

    public int getIndex(int position) {
        int result = Collections.binarySearch(this.m_Positions, position);
        if (result < 0) {
            result = -(result + 1);
        }
        if (result > 0) {
            --result;
        }
        return result;
    }

    public int getSize(int index) {
        if (index < 0 || index >= this.m_Sizes.size()) {
            return -1;
        }
        return this.m_Sizes.get(index);
    }

    public void setSize(int index, int size) {
        this.m_Sizes.set(index, size);
        this.updatePositions(index);
    }

    public void insertEntries(int start, int length, int value) {
        for (int i = 0; i < length; ++i) {
            this.m_Sizes.add(start + i, value);
        }
        this.updatePositions(start);
    }

    public void removeEntries(int start, int length) {
        for (int i = 0; i < length; ++i) {
            this.m_Sizes.remove(start);
        }
        this.updatePositions(start);
    }

    protected void updatePositions(int start) {
        if (this.m_Positions.size() != this.m_Sizes.size()) {
            while (this.m_Positions.size() < this.m_Sizes.size()) {
                this.m_Positions.add(start, 0);
            }
            while (this.m_Positions.size() > this.m_Sizes.size()) {
                this.m_Positions.remove(start);
            }
        }
        for (int i = start; i < this.m_Positions.size(); ++i) {
            if (i == 0) {
                this.m_Positions.set(i, 0);
                continue;
            }
            this.m_Positions.set(i, this.m_Positions.get(i - 1) + this.m_Sizes.get(i));
        }
    }
}

