/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.management.OS;
import adams.gui.core.GUIHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.net.URI;
import javax.swing.JLabel;

public class BrowserHelper {
    public static final String[] LINUX_BROWSERS = new String[]{"firefox", "chromium", "iron", "google-chrome", "opera", "epiphany", "mozilla", "netscape", "konqueror"};

    public static synchronized String openURL(String url) {
        return BrowserHelper.openURL(null, url);
    }

    public static synchronized String openURL(Component parent, String url) {
        return BrowserHelper.openURL(parent, url, true);
    }

    public static synchronized String openURL(Component parent, String url, boolean showDialog) {
        String result = null;
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(new URI(url));
            } else {
                System.err.println("Desktop not supported, using fallback to determine browser.");
                if (OS.isMac()) {
                    Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                    Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                    openURL.invoke(null, url);
                } else if (OS.isWindows()) {
                    Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
                } else {
                    String browser = null;
                    for (int count = 0; count < LINUX_BROWSERS.length && browser == null; ++count) {
                        if (Runtime.getRuntime().exec(new String[]{"which", LINUX_BROWSERS[count]}).waitFor() != 0) continue;
                        browser = LINUX_BROWSERS[count];
                        break;
                    }
                    if (browser == null) {
                        throw new Exception("Could not find web browser");
                    }
                    Runtime.getRuntime().exec(new String[]{browser, url});
                }
            }
        }
        catch (Exception e) {
            result = "Error attempting to launch web browser:\n" + e.getMessage();
            if (showDialog) {
                GUIHelper.showErrorMessage(parent, result);
            }
            System.err.println(result);
        }
        return result;
    }

    public static synchronized String openURL(Component parent, String cmd, String url, boolean showDialog) {
        String result = null;
        try {
            Runtime.getRuntime().exec(cmd + " " + url);
        }
        catch (Exception e) {
            result = "Error attempting to launch web browser '" + cmd + "':\n" + e.getMessage();
            if (showDialog) {
                GUIHelper.showErrorMessage(parent, result);
            }
            System.err.println(result);
        }
        return result;
    }

    public static JLabel createLink(String url, String text) {
        final String urlF = url;
        final JLabel result = new JLabel();
        result.setText(text == null || text.length() == 0 ? url : text);
        result.setToolTipText("Click to open link in browser");
        result.setForeground(Color.BLUE);
        result.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    BrowserHelper.openURL(urlF);
                } else {
                    super.mouseClicked(e);
                }
            }

            public void mouseEntered(MouseEvent e) {
                result.setForeground(Color.RED);
            }

            public void mouseExited(MouseEvent e) {
                result.setForeground(Color.BLUE);
            }
        });
        return result;
    }
}

