/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.io.PlaceholderFile;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.core.BaseListWithButtons;
import adams.gui.event.RemoveItemsEvent;
import adams.gui.event.RemoveItemsListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

public class FileListWithButtons
extends BaseListWithButtons {
    private static final long serialVersionUID = 4722609868753213745L;
    protected JButton m_ButtonAdd;
    protected JButton m_ButtonRemove;
    protected JButton m_ButtonRemoveAll;
    protected BaseFileChooser m_FileChooser;
    protected JButton m_ButtonMoveUp;
    protected JButton m_ButtonMoveDown;

    protected void initialize() {
        super.initialize();
        this.m_FileChooser = new BaseFileChooser();
        this.m_FileChooser.setMultiSelectionEnabled(true);
    }

    protected void initGUI() {
        super.initGUI();
        this.setModel(new DefaultListModel());
        this.setSelectionMode(2);
        this.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                FileListWithButtons.this.update();
            }
        });
        this.m_ButtonAdd = new JButton("Add");
        this.m_ButtonAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileListWithButtons.this.addFile();
            }
        });
        this.addToButtonsPanel(this.m_ButtonAdd);
        this.m_ButtonRemove = new JButton("Remove");
        this.m_ButtonRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileListWithButtons.this.removeFile(FileListWithButtons.this.getSelectedIndices());
            }
        });
        this.addToButtonsPanel(this.m_ButtonRemove);
        this.m_ButtonRemoveAll = new JButton("Remove all");
        this.m_ButtonRemoveAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileListWithButtons.this.removeAllFiles();
            }
        });
        this.addToButtonsPanel(this.m_ButtonRemoveAll);
        this.m_ButtonMoveUp = new JButton("Up");
        this.m_ButtonMoveUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileListWithButtons.this.moveUp();
            }
        });
        this.addToButtonsPanel(new JLabel());
        this.addToButtonsPanel(this.m_ButtonMoveUp);
        this.m_ButtonMoveDown = new JButton("Down");
        this.m_ButtonMoveDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileListWithButtons.this.moveDown();
            }
        });
        this.addToButtonsPanel(this.m_ButtonMoveDown);
        this.addRemoveItemsListener(new RemoveItemsListener(){

            public void removeItems(RemoveItemsEvent e) {
                if (e.hasIndices()) {
                    FileListWithButtons.this.removeFile(e.getIndices());
                }
            }
        });
    }

    public void addChoosableFileFilter(FileFilter filter) {
        this.m_FileChooser.addChoosableFileFilter(filter);
    }

    public void removeChoosableFileFilter(FileFilter filter) {
        this.m_FileChooser.removeChoosableFileFilter(filter);
    }

    public void setDialogTitle(String value) {
        this.m_FileChooser.setDialogTitle(value);
    }

    public String getDialogTitle() {
        return this.m_FileChooser.getDialogTitle();
    }

    public void setCurrentDirectory(File value) {
        this.m_FileChooser.setCurrentDirectory(value);
    }

    public File getCurrentDirectory() {
        return this.m_FileChooser.getCurrentDirectory();
    }

    protected void finishInit() {
        super.finishInit();
        this.update();
    }

    public void update() {
        this.updateButtons();
    }

    protected void updateButtons() {
        this.m_ButtonAdd.setEnabled(true);
        this.m_ButtonRemove.setEnabled(this.getSelectedIndices().length > 0);
        this.m_ButtonRemoveAll.setEnabled(this.getModel().getSize() > 0);
        this.m_ButtonMoveUp.setEnabled(this.canMoveUp());
        this.m_ButtonMoveDown.setEnabled(this.canMoveDown());
    }

    protected void addFile() {
        PlaceholderFile[] files;
        DefaultListModel model = (DefaultListModel)this.getModel();
        int retVal = this.m_FileChooser.showOpenDialog(this);
        if (retVal != 0) {
            return;
        }
        for (PlaceholderFile file : files = this.m_FileChooser.getSelectedPlaceholderFiles()) {
            model.addElement(file.toString());
        }
        this.update();
    }

    protected void removeFile(int[] indices) {
        DefaultListModel model = (DefaultListModel)this.getModel();
        for (int i = indices.length - 1; i >= 0; --i) {
            model.remove(indices[i]);
        }
        this.update();
    }

    protected void removeAllFiles() {
        ((DefaultListModel)this.getModel()).clear();
        this.update();
    }

    public void setFiles(File[] value) {
        DefaultListModel model = (DefaultListModel)this.getModel();
        model.clear();
        for (File file : value) {
            model.addElement(file.toString());
        }
        this.update();
    }

    protected File[] getFiles(int[] indices) {
        File[] result;
        DefaultListModel model = (DefaultListModel)this.getModel();
        if (indices != null) {
            result = new File[indices.length];
            for (int i = 0; i < indices.length; ++i) {
                result[i] = new PlaceholderFile((String)model.get(i));
            }
        } else {
            result = new File[model.getSize()];
            for (int i = 0; i < model.size(); ++i) {
                result[i] = new PlaceholderFile((String)model.get(i));
            }
        }
        return result;
    }

    public File[] getFiles() {
        return this.getFiles(null);
    }

    public File[] getSelectedFiles() {
        return this.getFiles(this.getSelectedIndices());
    }
}

