/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.gui.core.AbstractBaseTableModel;
import adams.gui.core.CustomSearchTableModel;
import adams.gui.core.SearchParameters;

public class KeyValuePairTableModel
extends AbstractBaseTableModel
implements CustomSearchTableModel {
    private static final long serialVersionUID = -8212085458244592181L;
    protected Object[][] m_Data;
    protected boolean m_Editable;
    protected boolean m_Modified;

    public KeyValuePairTableModel(Object[][] data) {
        this.m_Data = (Object[][])data.clone();
        this.m_Editable = false;
        this.m_Modified = false;
    }

    public void setEditable(boolean value) {
        this.m_Editable = value;
    }

    public boolean isEditable() {
        return this.m_Editable;
    }

    public void setModified(boolean value) {
        this.m_Modified = value;
    }

    public boolean isModified() {
        return this.m_Modified;
    }

    public int getRowCount() {
        if (this.m_Data == null) {
            return 0;
        }
        return this.m_Data.length;
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int column) {
        if (column == 0) {
            return "Name";
        }
        if (column == 1) {
            return "Value";
        }
        throw new IllegalArgumentException("Invalid column: " + column);
    }

    public Object getValueAt(int row, int column) {
        int pos;
        Object result = this.m_Data[row][column];
        if (column == 1 && result instanceof String && (pos = ((String)result).indexOf(10)) > -1) {
            result = ((String)result).substring(0, pos) + "...";
        }
        return result;
    }

    public String getKeyAt(int row) {
        return (String)this.m_Data[row][0];
    }

    public Object getValueAt(int row) {
        return this.m_Data[row][1];
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.m_Editable && columnIndex == 1;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 1) {
            this.m_Data[rowIndex][1] = aValue == null ? "" : aValue;
            this.m_Modified = true;
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    public Class getColumnClass(int column) {
        if (column == 0) {
            return String.class;
        }
        return Object.class;
    }

    public boolean isSearchMatch(SearchParameters params, int row) {
        if (params.matches((String)this.m_Data[row][0])) {
            return true;
        }
        return this.m_Data[row][1] instanceof String ? params.matches((String)this.m_Data[row][1]) : (this.m_Data[row][1] instanceof Integer ? params.matches((Integer)this.m_Data[row][1]) : this.m_Data[row][1] instanceof Double && params.matches((Double)this.m_Data[row][1]));
    }
}

