/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.gui.core.BaseList;
import adams.gui.core.SearchableList;
import adams.gui.core.SearchableListModel;
import adams.gui.core.SearchableWrapperListModel;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.ListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchableBaseList
extends BaseList
implements SearchableList {
    private static final long serialVersionUID = -5870481646786200108L;
    public static final String KEY_SEARCHSTRING = "search string";
    public static final String KEY_SEARCHREGEXP = "search reg exp";
    protected SearchableWrapperListModel m_Model;

    public SearchableBaseList() {
    }

    public SearchableBaseList(Object[] listData) {
        super(listData);
    }

    public SearchableBaseList(Vector<?> listData) {
        super(listData);
    }

    public SearchableBaseList(ListModel dataModel) {
        super(dataModel);
    }

    protected Class getListModelClass() {
        return ListModel.class;
    }

    protected Hashtable<String, Object> backupModelSettings(ListModel model) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        if (model instanceof SearchableListModel) {
            if (((SearchableListModel)model).getSeachString() != null) {
                result.put(KEY_SEARCHSTRING, ((SearchableListModel)model).getSeachString());
            }
            result.put(KEY_SEARCHREGEXP, ((SearchableListModel)model).isRegExpSearch());
        }
        return result;
    }

    protected void restoreModelSettings(ListModel model, Hashtable<String, Object> settings) {
        String search = null;
        boolean regexp = false;
        if (settings != null && model instanceof SearchableListModel) {
            search = (String)settings.get(KEY_SEARCHSTRING);
            regexp = (Boolean)settings.get(KEY_SEARCHREGEXP);
        }
        if (model instanceof SearchableListModel) {
            ((SearchableListModel)model).search(search, regexp);
        }
    }

    public synchronized void setModel(ListModel model) {
        if (!this.getListModelClass().isInstance(model)) {
            model = new DefaultListModel();
        }
        Hashtable<String, Object> settings = this.m_Model != null ? this.backupModelSettings(this.m_Model) : null;
        this.m_Model = new SearchableWrapperListModel(model);
        super.setModel(this.m_Model);
        this.restoreModelSettings(this.m_Model, settings);
    }

    public void setActualModel(ListModel value) {
        this.m_Model.setActualModel(value);
    }

    public ListModel getActualModel() {
        return this.m_Model.getActualModel();
    }

    @Override
    public int getActualIndex(int index) {
        return this.m_Model.getActualIndex(index);
    }

    @Override
    public int getActualSize() {
        return this.m_Model.getActualSize();
    }

    @Override
    public void search(String searchString, boolean regexp) {
        this.m_Model.search(searchString, regexp);
    }

    @Override
    public String getSeachString() {
        return this.m_Model.getSeachString();
    }

    @Override
    public boolean isRegExpSearch() {
        return this.m_Model.isRegExpSearch();
    }
}

