/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.io.SpreadSheet;
import adams.gui.core.SpreadSheetTable;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class SpreadSheetCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = -6070112998601610760L;

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component result = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        SpreadSheet.Cell cell = ((SpreadSheetTable)table).getCellAt(row, column);
        if (cell != null) {
            if (cell.isMissing()) {
                ((JLabel)result).setToolTipText("missing");
                if (isSelected) {
                    ((JLabel)result).setBackground(Color.GRAY);
                } else {
                    ((JLabel)result).setBackground(Color.LIGHT_GRAY);
                }
            } else {
                ((JLabel)result).setToolTipText(null);
                if (isSelected) {
                    ((JLabel)result).setBackground(table.getSelectionBackground());
                } else {
                    ((JLabel)result).setBackground(table.getBackground());
                }
            }
            if (cell.isNumeric()) {
                ((JLabel)result).setHorizontalAlignment(4);
            } else {
                ((JLabel)result).setHorizontalAlignment(2);
            }
        } else {
            ((JLabel)result).setToolTipText("missing");
            if (isSelected) {
                ((JLabel)result).setBackground(Color.GRAY);
            } else {
                ((JLabel)result).setBackground(Color.LIGHT_GRAY);
            }
        }
        return result;
    }
}

