/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.gui.core.BasePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JToolBar;

public abstract class ToolBarPanel
extends BasePanel {
    private static final long serialVersionUID = -5948851044915629484L;
    protected ToolBarLocation m_Location;
    protected JToolBar m_ToolBar;
    protected BasePanel m_ContentPanel;

    protected void initialize() {
        super.initialize();
        this.m_Location = ToolBarLocation.NORTH;
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_ContentPanel = new BasePanel(new BorderLayout());
        this.add((Component)this.m_ContentPanel, "Center");
        this.m_ToolBar = new JToolBar();
        this.m_ToolBar.setFloatable(false);
        this.add((Component)this.m_ToolBar, "North");
    }

    protected abstract void initActions();

    protected abstract void initToolBar();

    protected void finishInit() {
        super.finishInit();
        this.initActions();
        this.initToolBar();
        this.updateActions();
    }

    public void setToolBarLocation(ToolBarLocation value) {
        this.m_Location = value;
        switch (this.m_Location) {
            case HIDDEN: {
                this.m_ToolBar.setVisible(false);
                break;
            }
            case NORTH: {
                this.add((Component)this.m_ToolBar, "North");
                this.m_ToolBar.setOrientation(0);
                this.m_ToolBar.setVisible(true);
                break;
            }
            case SOUTH: {
                this.add((Component)this.m_ToolBar, "South");
                this.m_ToolBar.setOrientation(0);
                this.m_ToolBar.setVisible(true);
                break;
            }
            case WEST: {
                this.add((Component)this.m_ToolBar, "West");
                this.m_ToolBar.setOrientation(1);
                this.m_ToolBar.setVisible(true);
                break;
            }
            case EAST: {
                this.add((Component)this.m_ToolBar, "East");
                this.m_ToolBar.setOrientation(1);
                this.m_ToolBar.setVisible(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled toolbar location: " + (Object)((Object)value));
            }
        }
    }

    public ToolBarLocation getToolBarLocation() {
        return this.m_Location;
    }

    public void addToToolBar(AbstractAction action) {
        this.m_ToolBar.add(action);
    }

    public void addToToolBar(JComponent comp) {
        this.m_ToolBar.add(comp);
    }

    public void removeFromToolBar(JComponent comp) {
        this.m_ToolBar.remove(comp);
    }

    public void addSeparator() {
        this.m_ToolBar.addSeparator();
    }

    public int getToolBarComponentCount() {
        return this.m_ToolBar.getComponentCount();
    }

    public Component getToolBarComponentAtIndex(int index) {
        return this.m_ToolBar.getComponentAtIndex(index);
    }

    public JToolBar getToolBar() {
        return this.m_ToolBar;
    }

    public BasePanel getContentPanel() {
        return this.m_ContentPanel;
    }

    public void setFloatable(boolean value) {
        this.m_ToolBar.setFloatable(value);
    }

    public boolean isFloatable() {
        return this.m_ToolBar.isFloatable();
    }

    protected abstract void updateActions();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ToolBarLocation {
        HIDDEN,
        NORTH,
        SOUTH,
        WEST,
        EAST;

    }
}

