/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe.globalactorstree;

import adams.gui.core.BaseTreeNode;
import adams.gui.core.dotnotationtree.DotNotationTree;
import adams.gui.flow.tree.Node;
import adams.gui.flow.tree.Tree;
import adams.gui.goe.globalactorstree.GlobalActorsNode;
import adams.gui.goe.globalactorstree.GlobalActorsTreeRenderer;
import java.util.Enumeration;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalActorsTree
extends DotNotationTree<GlobalActorsNode> {
    private static final long serialVersionUID = 1489354474021395304L;
    protected Tree m_FlowTree;

    public GlobalActorsTree() {
        this.setSorted(true);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_FlowTree = null;
    }

    public void setTree(Tree value) {
        this.m_FlowTree = value;
    }

    public Tree getFlow() {
        return this.m_FlowTree;
    }

    @Override
    protected TreeCellRenderer getDefaultRenderer() {
        return new GlobalActorsTreeRenderer();
    }

    @Override
    protected String getRootNodeLabel() {
        if (this.m_FlowTree != null && this.m_FlowTree.getModel().getRoot() != null) {
            return ((Node)this.m_FlowTree.getModel().getRoot()).getActor().getName();
        }
        return "Flow";
    }

    @Override
    protected GlobalActorsNode newNode(String label) {
        Node global;
        String classname = null;
        if (this.m_FlowTree != null && (global = this.m_FlowTree.locate(label)) != null) {
            classname = global.getActor().getClass().getName();
        }
        GlobalActorsNode result = new GlobalActorsNode(label);
        result.setClassname(classname);
        return result;
    }

    @Override
    protected void postAddLeaf(GlobalActorsNode node, String item) {
        String classname = null;
        if (this.m_FlowTree != null) {
            Node global = this.m_FlowTree.locate(item);
            if (global != null) {
                classname = global.getActor().getClass().getName();
            }
            node.setClassname(classname);
        }
        super.postAddLeaf(node, item);
    }

    public GlobalActorsNode findGlobalActor(String name) {
        BaseTreeNode node;
        GlobalActorsNode result = null;
        if (name != null && name.length() > 0 && (node = (BaseTreeNode)this.getTreeModel().getRoot()) != null) {
            Enumeration<TreeNode> enm = node.breadthFirstEnumeration();
            while (enm.hasMoreElements()) {
                GlobalActorsNode child;
                node = (BaseTreeNode)enm.nextElement();
                if (!(node instanceof GlobalActorsNode) || !(child = (GlobalActorsNode)node).isGlobalActor() || !child.getLabel().equals(name)) continue;
                result = child;
                break;
            }
        }
        return result;
    }

    public void selectGlobalActor(String name) {
        GlobalActorsNode node = this.findGlobalActor(name);
        if (node != null) {
            TreePath path = new TreePath(node.getPath());
            this.setSelectionPath(path);
        }
    }
}

