/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.scripting;

import adams.core.option.OptionUtils;
import adams.data.io.input.AbstractDataContainerReader;
import adams.gui.scripting.AbstractDataContainerPanelScriptlet;
import adams.gui.visualization.container.ContainerManager;
import java.util.Vector;

public class AddDataFile
extends AbstractDataContainerPanelScriptlet {
    private static final long serialVersionUID = -3048379013750352301L;
    public static final String ACTION = "add-data-file";

    public String getAction() {
        return ACTION;
    }

    protected String getOptionsDescription() {
        return "<datacontainer-reader scheme>";
    }

    public String getDescription() {
        return "Adds the data container loaded via the given reader to the currently loaded ones.";
    }

    public String process(String options) throws Exception {
        Vector<Object> data;
        String result = null;
        AbstractDataContainerReader reader = AbstractDataContainerReader.forCommandLine(options);
        this.addUndoPoint("Saving undo data...", "Loading data with: " + OptionUtils.getCommandLine(reader));
        try {
            data = reader.read();
        }
        catch (Exception e) {
            data = new Vector();
            result = "Error reading data: " + e;
            e.printStackTrace();
        }
        if (result == null) {
            Object manager = this.getDataContainerPanel().getContainerManager();
            Vector cont = new Vector();
            for (int i = 0; i < data.size(); ++i) {
                cont.add(((ContainerManager)manager).newContainer((Comparable)data.get(i)));
            }
            ((ContainerManager)manager).addAll(cont);
        }
        this.showStatus("");
        return result;
    }
}

