/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.selection;

import adams.gui.event.DoubleClickEvent;
import adams.gui.event.DoubleClickListener;
import adams.gui.selection.AbstractSelectionDialog;
import adams.gui.selection.AbstractTableBasedSelectionPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.lang.reflect.Array;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTableBasedSelectionDialog<T, P extends AbstractTableBasedSelectionPanel>
extends AbstractSelectionDialog<T, P> {
    private static final long serialVersionUID = -5900377961538534246L;
    protected T[] m_Current;

    protected AbstractTableBasedSelectionDialog(Dialog owner, String title) {
        super(owner, title);
    }

    protected AbstractTableBasedSelectionDialog(Frame owner, String title) {
        super(owner, title);
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.m_Panel = this.newPanel();
        ((AbstractTableBasedSelectionPanel)this.m_Panel).addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                AbstractTableBasedSelectionDialog.this.update();
            }
        });
        this.getContentPane().add((Component)this.m_Panel, "Center");
        this.pack();
    }

    @Override
    protected void finishInit() {
        super.finishInit();
        this.m_Current = (Object[])Array.newInstance(((AbstractTableBasedSelectionPanel)this.m_Panel).getItemClass(), 0);
    }

    protected abstract P newPanel();

    public P getPanel() {
        return (P)((AbstractTableBasedSelectionPanel)this.m_Panel);
    }

    protected void update() {
        this.m_ButtonApprove.setEnabled(((AbstractTableBasedSelectionPanel)this.m_Panel).getSelectedRowCount() >= 1);
    }

    public void setMultipleSelection(boolean value) {
        ((AbstractTableBasedSelectionPanel)this.m_Panel).setMultipleSelection(value);
    }

    public boolean isMultipleSelection() {
        return ((AbstractTableBasedSelectionPanel)this.m_Panel).isMultipleSelection();
    }

    public void setItem(T value) {
        ((AbstractTableBasedSelectionPanel)this.m_Panel).setItem(value);
    }

    public T getItem() {
        return ((AbstractTableBasedSelectionPanel)this.m_Panel).getItem();
    }

    public void setItems(T[] value) {
        this.m_Current = (Object[])value.clone();
        ((AbstractTableBasedSelectionPanel)this.m_Panel).setItems(this.m_Current);
    }

    public T[] getItems() {
        return this.m_Current;
    }

    @Override
    protected void beforeShow() {
        super.beforeShow();
        ((AbstractTableBasedSelectionPanel)this.m_Panel).addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                AbstractTableBasedSelectionDialog.this.m_ButtonApprove.setEnabled(((AbstractTableBasedSelectionPanel)AbstractTableBasedSelectionDialog.this.m_Panel).getItems().length > 0);
            }
        });
        ((AbstractTableBasedSelectionPanel)this.m_Panel).addDoubleClickListener(new DoubleClickListener(){

            public void doubleClickOccurred(DoubleClickEvent e) {
                if (((AbstractTableBasedSelectionPanel)AbstractTableBasedSelectionDialog.this.m_Panel).getItem() != null) {
                    AbstractTableBasedSelectionDialog.this.m_ButtonApprove.doClick();
                }
            }
        });
        ((AbstractTableBasedSelectionPanel)this.m_Panel).setItems(this.m_Current);
        ((AbstractTableBasedSelectionPanel)this.m_Panel).scrollIntoView();
        ((AbstractTableBasedSelectionPanel)this.m_Panel).grabFocus();
    }

    @Override
    protected void beforeHide() {
        super.beforeHide();
        if (this.m_Option == 0) {
            this.m_Current = ((AbstractTableBasedSelectionPanel)this.m_Panel).getItems();
        }
        this.cleanUp();
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        ((AbstractTableBasedSelectionPanel)this.m_Panel).cleanUp();
    }
}

