/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.core.Properties;
import adams.data.sequence.XYSequence;
import adams.db.SequenceProvider;
import adams.env.Environment;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTabbedPane;
import adams.gui.scripting.SyntaxDocument;
import adams.gui.visualization.sequence.XYSequenceContainerManager;
import adams.gui.visualization.sequence.XYSequencePanel;
import adams.gui.visualization.sequence.XYSequenceTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.Document;

public abstract class AbstractSequenceViewerPanel
extends BasePanel {
    private static final long serialVersionUID = -2118371024397646256L;
    public static final String FILENAME = "SequenceViewerPanel.props";
    protected JPanel m_PanelSQL;
    protected JTextPane m_TextSQL;
    protected JComboBox m_ComboboxTemplates;
    protected JButton m_ButtonExecute;
    protected JPanel m_PanelResults;
    protected BaseTabbedPane m_TabbedPaneResults;

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_PanelSQL = new JPanel(new BorderLayout());
        this.add((Component)this.m_PanelSQL, "North");
        this.m_TextSQL = new JTextPane();
        this.m_TextSQL.setDocument(AbstractSequenceViewerPanel.createDocument());
        this.m_TextSQL.setPreferredSize(new Dimension(400, 300));
        this.m_PanelSQL.add((Component)new BaseScrollPane(this.m_TextSQL), "Center");
        JPanel panel2 = new JPanel(new BorderLayout());
        this.m_PanelSQL.add((Component)panel2, "East");
        JPanel panel = new JPanel(new GridLayout(2, 1));
        panel2.add((Component)panel, "North");
        this.m_ComboboxTemplates = new JComboBox<String>(new Vector<String>(this.getSequenceProvider().getTemplates().keySet()));
        this.m_ComboboxTemplates.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AbstractSequenceViewerPanel.this.loadTemplate();
            }
        });
        panel.add(this.m_ComboboxTemplates);
        this.m_ButtonExecute = new JButton("Execute");
        this.m_ButtonExecute.setMnemonic('E');
        this.m_ButtonExecute.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AbstractSequenceViewerPanel.this.execute();
            }
        });
        panel.add(this.m_ButtonExecute);
        this.m_PanelResults = new JPanel(new BorderLayout());
        this.add((Component)this.m_PanelResults, "Center");
        this.m_TabbedPaneResults = new BaseTabbedPane();
        this.m_PanelResults.add((Component)this.m_TabbedPaneResults, "Center");
    }

    protected abstract SequenceProvider getSequenceProvider();

    public static Document createDocument() {
        Properties props = Environment.getInstance().read("sequence viewer");
        SyntaxDocument result = new SyntaxDocument(props);
        return result;
    }

    protected void loadTemplate() {
        if (this.m_ComboboxTemplates.getSelectedIndex() == -1) {
            return;
        }
        this.m_TextSQL.setText(this.getSequenceProvider().getTemplates().get(this.m_ComboboxTemplates.getSelectedItem()));
    }

    protected synchronized void execute() {
        int i;
        if (this.m_TextSQL.getText().trim().length() == 0) {
            return;
        }
        Vector<XYSequence> sequences = this.getSequenceProvider().retrieve(this.m_TextSQL.getText());
        this.m_TabbedPaneResults.removeAll();
        for (i = 0; i < sequences.size(); ++i) {
            XYSequenceTable table = new XYSequenceTable();
            table.setModel(new XYSequenceTable.Model(sequences.get(i)));
            table.setAutoResizeMode(0);
            this.m_TabbedPaneResults.addTab(sequences.get(i).getID(), new BaseScrollPane(table));
        }
        XYSequencePanel panel = new XYSequencePanel();
        this.m_TabbedPaneResults.addTab("Graph", panel);
        ((XYSequenceContainerManager)panel.getContainerManager()).startUpdate();
        for (i = 0; i < sequences.size(); ++i) {
            ((XYSequenceContainerManager)panel.getContainerManager()).add(((XYSequenceContainerManager)panel.getContainerManager()).newContainer(sequences.get(i)));
        }
        ((XYSequenceContainerManager)panel.getContainerManager()).finishUpdate();
    }
}

