/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.core.Utils;
import adams.core.option.OptionUtils;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.GUIHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class OptionTree
extends BasePanel {
    private static final long serialVersionUID = 8177217505366217714L;
    public static final String LABEL_ROOT = "<root>";
    public static final String LABEL_NESTED = "<nested>";
    protected JTextField m_TextOptionsFull;
    protected JCheckBox m_CheckBoxPropsFile;
    protected JButton m_ButtonUpdate;
    protected JTextField m_TextOptionsSelected;
    protected JButton m_ButtonCopy;
    protected JTree m_TreeOptions;

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new FlowLayout(0));
        this.add((Component)panel, "North");
        this.m_TextOptionsFull = new JTextField(40);
        this.m_TextOptionsFull.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                OptionTree.this.update();
            }

            public void insertUpdate(DocumentEvent e) {
                OptionTree.this.update();
            }

            public void removeUpdate(DocumentEvent e) {
                OptionTree.this.update();
            }
        });
        JLabel label = new JLabel("Full options");
        label.setDisplayedMnemonic('F');
        label.setLabelFor(this.m_TextOptionsFull);
        panel.add(label);
        panel.add(this.m_TextOptionsFull);
        this.m_CheckBoxPropsFile = new JCheckBox("from Props file");
        this.m_CheckBoxPropsFile.setMnemonic('P');
        panel.add(this.m_CheckBoxPropsFile);
        this.m_ButtonUpdate = new JButton("Update");
        this.m_ButtonUpdate.setMnemonic('U');
        this.m_ButtonUpdate.setIcon(GUIHelper.getIcon("refresh.gif"));
        this.m_ButtonUpdate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OptionTree.this.updateTree();
            }
        });
        panel.add(this.m_ButtonUpdate);
        this.m_TreeOptions = new JTree();
        this.m_TreeOptions.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                OptionTree.this.generatePartialOptions();
            }
        });
        this.add(new BaseScrollPane(this.m_TreeOptions));
        panel = new JPanel(new FlowLayout(0));
        this.add((Component)panel, "South");
        this.m_TextOptionsSelected = new JTextField(50);
        this.m_TextOptionsSelected.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                OptionTree.this.update();
            }

            public void insertUpdate(DocumentEvent e) {
                OptionTree.this.update();
            }

            public void removeUpdate(DocumentEvent e) {
                OptionTree.this.update();
            }
        });
        label = new JLabel("Selected options");
        label.setDisplayedMnemonic('S');
        label.setLabelFor(this.m_TextOptionsSelected);
        panel.add(label);
        panel.add(this.m_TextOptionsSelected);
        this.m_ButtonCopy = new JButton("Copy");
        this.m_ButtonCopy.setMnemonic('C');
        this.m_ButtonCopy.setIcon(GUIHelper.getIcon("copy.gif"));
        this.m_ButtonCopy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIHelper.copyToClipboard(OptionTree.this.m_TextOptionsSelected.getText());
            }
        });
        panel.add(this.m_ButtonCopy);
        this.update();
        this.updateTree();
    }

    protected void update() {
        this.m_ButtonCopy.setEnabled(this.m_TextOptionsSelected.getText().length() > 0);
    }

    protected void parse(DefaultMutableTreeNode parent, String s) {
        try {
            String[] options = OptionUtils.splitOptions(s);
            for (int i = 0; i < options.length; ++i) {
                String currOption = options[i].trim();
                DefaultMutableTreeNode node = currOption.indexOf(" ") > -1 ? new DefaultMutableTreeNode(LABEL_NESTED) : new DefaultMutableTreeNode(currOption);
                parent.add(node);
                if (currOption.indexOf(" ") <= -1) continue;
                this.parse(node, currOption);
            }
        }
        catch (Exception e) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(e.toString());
            parent.add(node);
            e.printStackTrace();
        }
    }

    protected void updateTree() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(LABEL_ROOT);
        if (this.m_TextOptionsFull.getText().length() > 0) {
            String options = this.m_TextOptionsFull.getText();
            if (this.m_CheckBoxPropsFile.isSelected()) {
                options = Utils.unbackQuoteChars(options);
            }
            this.parse(root, options);
        }
        this.m_TreeOptions.setModel(new DefaultTreeModel(root));
    }

    protected String getOptions(DefaultMutableTreeNode node) {
        Vector<String> options = new Vector<String>();
        if (!node.toString().equals(LABEL_ROOT) && !node.toString().equals(LABEL_NESTED)) {
            options.add(node.toString());
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            options.add(this.getOptions((DefaultMutableTreeNode)node.getChildAt(i)));
        }
        return OptionUtils.joinOptions(options.toArray(new String[options.size()]));
    }

    protected void generatePartialOptions() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_TreeOptions.getSelectionPath().getLastPathComponent();
        this.m_TextOptionsSelected.setText(this.getOptions(node));
    }
}

