/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.core.CleanUpHandler;
import adams.core.Properties;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.gui.chooser.DirectoryChooserPanel;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.SearchPanel;
import adams.gui.core.SearchableBaseList;
import adams.gui.event.SearchEvent;
import adams.gui.event.SearchListener;
import adams.gui.tools.previewbrowser.AbstractArchiveHandler;
import adams.gui.tools.previewbrowser.AbstractContentHandler;
import adams.gui.tools.previewbrowser.CreatingPreviewPanel;
import adams.gui.tools.previewbrowser.NoPreviewAvailablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PreviewBrowserPanel
extends BasePanel {
    private static final long serialVersionUID = 5284765971012530865L;
    public static final String FILENAME = "PreviewBrowser.props";
    public static final String PREFIX_PREFERRED_CONTENT_HANDLER = "PreferredContentHandler-";
    public static final String PREFIX_PREFERRED_ARCHIVE_HANDLER = "PreferredArchiveHandler-";
    protected static Properties m_Properties;
    protected BaseSplitPane m_SplitPane;
    protected DirectoryChooserPanel m_PanelDir;
    protected BasePanel m_PanelBrowsing;
    protected BasePanel m_PanelLocalFiles;
    protected SearchableBaseList m_ListLocalFiles;
    protected DefaultListModel m_ModelLocalFiles;
    protected SearchPanel m_SearchLocalFiles;
    protected BasePanel m_PanelArchiveFiles;
    protected SearchableBaseList m_ListArchiveFiles;
    protected DefaultListModel m_ModelArchiveFiles;
    protected SearchPanel m_SearchArchiveFiles;
    protected BasePanel m_PanelContent;
    protected BasePanel m_PanelView;
    protected BasePanel m_PanelContentHandlers;
    protected JComboBox m_ComboBoxContentHandlers;
    protected DefaultComboBoxModel m_ModelContentHandlers;
    protected boolean m_IgnoreContentHandlerChanges;
    protected BasePanel m_PanelArchiveHandlers;
    protected JComboBox m_ComboBoxArchiveHandlers;
    protected DefaultComboBoxModel m_ModelArchiveHandlers;
    protected boolean m_IgnoreArchiveHandlerChanges;
    protected AbstractArchiveHandler m_ArchiveHandler;
    protected File m_CurrentFile;

    protected void initialize() {
        super.initialize();
        this.m_ArchiveHandler = null;
        this.m_IgnoreContentHandlerChanges = false;
        this.m_IgnoreArchiveHandlerChanges = false;
        this.m_CurrentFile = null;
    }

    protected void initGUI() {
        super.initGUI();
        Properties props = PreviewBrowserPanel.getProperties();
        this.setLayout(new BorderLayout());
        this.m_SplitPane = new BaseSplitPane(1);
        this.m_SplitPane.setOneTouchExpandable(true);
        this.m_SplitPane.setDividerLocation(props.getInteger("DividerLocation", 200));
        this.add((Component)this.m_SplitPane, "Center");
        this.m_PanelBrowsing = new BasePanel(new GridLayout(2, 1));
        this.m_SplitPane.setLeftComponent(this.m_PanelBrowsing);
        this.m_PanelLocalFiles = new BasePanel(new BorderLayout(0, 5));
        this.m_PanelBrowsing.add(this.m_PanelLocalFiles);
        this.m_PanelLocalFiles.setBorder(BorderFactory.createTitledBorder("Files"));
        this.m_PanelDir = new DirectoryChooserPanel(props.getString("InitialDir", "%h"));
        this.m_PanelDir.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PreviewBrowserPanel.this.refreshLocalFiles();
            }
        });
        this.m_PanelLocalFiles.add((Component)this.m_PanelDir, "North");
        this.m_ModelLocalFiles = new DefaultListModel();
        this.m_ListLocalFiles = new SearchableBaseList((ListModel)this.m_ModelLocalFiles);
        this.m_ListLocalFiles.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                PreviewBrowserPanel.this.displayLocalFile();
            }
        });
        this.m_PanelLocalFiles.add((Component)new BaseScrollPane(this.m_ListLocalFiles), "Center");
        this.m_SearchLocalFiles = new SearchPanel(SearchPanel.LayoutType.VERTICAL, false);
        this.m_SearchLocalFiles.addSearchListener(new SearchListener(){

            public void searchInitiated(SearchEvent e) {
                PreviewBrowserPanel.this.m_ListLocalFiles.search(e.getParameters().getSearchString(), e.getParameters().isRegExp());
            }
        });
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(this.m_SearchLocalFiles);
        this.m_PanelLocalFiles.add((Component)panel, "South");
        this.m_PanelArchiveFiles = new BasePanel(new BorderLayout());
        this.m_PanelBrowsing.add(this.m_PanelArchiveFiles);
        this.m_PanelArchiveFiles.setVisible(false);
        this.m_PanelArchiveFiles.setBorder(BorderFactory.createTitledBorder("Archive"));
        this.m_ModelArchiveFiles = new DefaultListModel();
        this.m_ListArchiveFiles = new SearchableBaseList((ListModel)this.m_ModelArchiveFiles);
        this.m_ListArchiveFiles.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                PreviewBrowserPanel.this.displayArchiveContent();
            }
        });
        this.m_PanelArchiveFiles.add((Component)new BaseScrollPane(this.m_ListArchiveFiles), "Center");
        this.m_SearchArchiveFiles = new SearchPanel(SearchPanel.LayoutType.VERTICAL, false);
        this.m_SearchArchiveFiles.addSearchListener(new SearchListener(){

            public void searchInitiated(SearchEvent e) {
                PreviewBrowserPanel.this.m_ListArchiveFiles.search(e.getParameters().getSearchString(), e.getParameters().isRegExp());
            }
        });
        panel = new JPanel(new FlowLayout(0));
        panel.add(this.m_SearchArchiveFiles);
        this.m_PanelArchiveFiles.add((Component)panel, "South");
        this.m_PanelArchiveHandlers = new BasePanel(new FlowLayout(0));
        this.m_PanelArchiveHandlers.setVisible(false);
        this.m_PanelArchiveFiles.add((Component)this.m_PanelArchiveHandlers, "South");
        this.m_ModelArchiveHandlers = new DefaultComboBoxModel();
        this.m_ComboBoxArchiveHandlers = new JComboBox(this.m_ModelArchiveHandlers);
        this.m_ComboBoxArchiveHandlers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (PreviewBrowserPanel.this.m_IgnoreArchiveHandlerChanges) {
                    return;
                }
                PreviewBrowserPanel.this.updatePreferredArchiveHandler();
                PreviewBrowserPanel.this.displayArchiveContent();
            }
        });
        this.m_PanelArchiveHandlers.add(new JLabel("Preferred handler"));
        this.m_PanelArchiveHandlers.add(this.m_ComboBoxArchiveHandlers);
        this.m_PanelContent = new BasePanel(new BorderLayout());
        this.m_SplitPane.setRightComponent(this.m_PanelContent);
        this.m_PanelView = new BasePanel(new BorderLayout());
        this.m_PanelContent.add((Component)this.m_PanelView, "Center");
        this.m_PanelContentHandlers = new BasePanel(new FlowLayout(0));
        this.m_PanelContentHandlers.setVisible(false);
        this.m_PanelContent.add((Component)this.m_PanelContentHandlers, "South");
        this.m_ModelContentHandlers = new DefaultComboBoxModel();
        this.m_ComboBoxContentHandlers = new JComboBox(this.m_ModelContentHandlers);
        this.m_ComboBoxContentHandlers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (PreviewBrowserPanel.this.m_IgnoreContentHandlerChanges) {
                    return;
                }
                PreviewBrowserPanel.this.updatePreferredContentHandler();
                if (PreviewBrowserPanel.this.m_CurrentFile != null) {
                    PreviewBrowserPanel.this.displayLocalContent(PreviewBrowserPanel.this.m_CurrentFile);
                }
            }
        });
        this.m_PanelContentHandlers.add(new JLabel("Preferred handler"));
        this.m_PanelContentHandlers.add(this.m_ComboBoxContentHandlers);
    }

    protected void finishInit() {
        super.finishInit();
        this.refreshLocalFiles();
    }

    protected synchronized void refreshLocalFiles() {
        File dir = (File)this.m_PanelDir.getCurrent();
        Object[] files = dir.listFiles();
        Arrays.sort(files);
        this.m_ModelLocalFiles.clear();
        for (Object file : files) {
            if (((File)file).isDirectory()) continue;
            this.m_ModelLocalFiles.addElement(((File)file).getName());
        }
        this.m_ListLocalFiles.search(this.m_ListLocalFiles.getSeachString(), this.m_ListLocalFiles.isRegExpSearch());
        this.m_ModelArchiveFiles.clear();
        this.m_PanelArchiveFiles.setVisible(false);
    }

    protected void displayView(final JPanel panel) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (PreviewBrowserPanel.this.m_PanelView.getComponentCount() > 0 && PreviewBrowserPanel.this.m_PanelView.getComponent(0) instanceof CleanUpHandler) {
                    ((CleanUpHandler)((Object)PreviewBrowserPanel.this.m_PanelView.getComponent(0))).cleanUp();
                }
                PreviewBrowserPanel.this.m_PanelView.removeAll();
                PreviewBrowserPanel.this.m_PanelView.add((Component)panel, "Center");
                PreviewBrowserPanel.this.m_SplitPane.validate();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    protected void displayCreatingView() {
        this.displayView(new CreatingPreviewPanel());
    }

    protected synchronized void displayLocalFile() {
        if (this.m_ListLocalFiles.getSelectedIndex() < 0) {
            return;
        }
        PlaceholderFile localFile = new PlaceholderFile(((File)this.m_PanelDir.getCurrent()).getAbsolutePath() + File.separator + this.m_ListLocalFiles.getSelectedValue());
        if (AbstractArchiveHandler.hasHandler(localFile)) {
            this.m_PanelArchiveFiles.setVisible(true);
            Vector<Class> handlers = AbstractArchiveHandler.getHandlersForFile(localFile);
            this.m_IgnoreArchiveHandlerChanges = true;
            this.m_ModelArchiveHandlers.removeAllElements();
            for (Class cls : handlers) {
                this.m_ModelArchiveHandlers.addElement(cls.getName());
            }
            this.m_PanelArchiveHandlers.setVisible(this.m_ModelArchiveHandlers.getSize() > 1);
            AbstractArchiveHandler preferred = this.getPreferredArchiveHandler(localFile);
            this.m_ComboBoxArchiveHandlers.setSelectedIndex(0);
            if (preferred != null) {
                for (int i = 0; i < handlers.size(); ++i) {
                    if (preferred.getClass() != handlers.get(i)) continue;
                    this.m_ComboBoxArchiveHandlers.setSelectedIndex(i);
                    break;
                }
            }
            this.m_IgnoreArchiveHandlerChanges = false;
            try {
                Class<?> cls = Class.forName((String)this.m_ComboBoxArchiveHandlers.getSelectedItem());
                this.m_ArchiveHandler = (AbstractArchiveHandler)cls.newInstance();
            }
            catch (Exception e) {
                this.m_ArchiveHandler = null;
                System.err.println("Failed to obtain archive handler for '" + localFile + "':");
                e.printStackTrace();
            }
        } else {
            this.m_ArchiveHandler = null;
        }
        this.m_ModelArchiveFiles.clear();
        this.m_PanelArchiveFiles.setVisible(this.m_ArchiveHandler != null);
        this.m_PanelView.removeAll();
        if (this.m_ArchiveHandler == null) {
            this.displayLocalContent(localFile);
        } else {
            String[] files;
            this.m_CurrentFile = null;
            this.m_ArchiveHandler.setArchive(localFile);
            for (String file : files = this.m_ArchiveHandler.getFiles()) {
                this.m_ModelArchiveFiles.addElement(file);
            }
        }
        this.m_ListArchiveFiles.search(this.m_ListArchiveFiles.getSeachString(), this.m_ListArchiveFiles.isRegExpSearch());
    }

    protected void displayLocalContent(final File localFile) {
        this.m_CurrentFile = localFile;
        this.displayCreatingView();
        SwingWorker worker = new SwingWorker(){
            JPanel contentPanel;

            protected Object doInBackground() throws Exception {
                this.contentPanel = new NoPreviewAvailablePanel();
                if (AbstractContentHandler.hasHandler(localFile)) {
                    Vector<Class> handlers = AbstractContentHandler.getHandlersForFile(localFile);
                    PreviewBrowserPanel.this.m_IgnoreContentHandlerChanges = true;
                    PreviewBrowserPanel.this.m_ModelContentHandlers.removeAllElements();
                    for (Class cls : handlers) {
                        PreviewBrowserPanel.this.m_ModelContentHandlers.addElement(cls.getName());
                    }
                    PreviewBrowserPanel.this.m_PanelContentHandlers.setVisible(PreviewBrowserPanel.this.m_ModelContentHandlers.getSize() > 1);
                    AbstractContentHandler preferred = PreviewBrowserPanel.this.getPreferredContentHandler(localFile);
                    PreviewBrowserPanel.this.m_ComboBoxContentHandlers.setSelectedIndex(0);
                    if (preferred != null) {
                        for (int i = 0; i < handlers.size(); ++i) {
                            if (preferred.getClass() != handlers.get(i)) continue;
                            PreviewBrowserPanel.this.m_ComboBoxContentHandlers.setSelectedIndex(i);
                            break;
                        }
                    }
                    PreviewBrowserPanel.this.m_IgnoreContentHandlerChanges = false;
                    try {
                        Class<?> cls = Class.forName((String)PreviewBrowserPanel.this.m_ComboBoxContentHandlers.getSelectedItem());
                        AbstractContentHandler contentHandler = (AbstractContentHandler)cls.newInstance();
                        this.contentPanel = contentHandler.getPreview(localFile);
                    }
                    catch (Exception e) {
                        Object contentHandler = null;
                        System.err.println("Failed to obtain content handler for '" + localFile + "':");
                        e.printStackTrace();
                    }
                }
                return null;
            }

            protected void done() {
                PreviewBrowserPanel.this.displayView(this.contentPanel);
                super.done();
            }
        };
        worker.execute();
    }

    protected synchronized void displayArchiveContent() {
        if (this.m_ListArchiveFiles.getSelectedIndex() < 0) {
            return;
        }
        this.displayCreatingView();
        NoPreviewAvailablePanel contentPanel = new NoPreviewAvailablePanel();
        String selFile = (String)this.m_ListArchiveFiles.getSelectedValue();
        try {
            File tmpFile = File.createTempFile("adams-fcb-", "." + FileUtils.getExtension(selFile), FileUtils.getTempDirectory());
            if (this.m_ArchiveHandler.extract(selFile, tmpFile)) {
                this.displayLocalContent(tmpFile);
                return;
            }
            System.err.println("Failed to extract file '" + selFile + "'!");
        }
        catch (Exception e) {
            System.err.println("Failed to extract file '" + selFile + "':");
            e.printStackTrace();
        }
        this.displayView(contentPanel);
    }

    protected AbstractContentHandler getPreferredContentHandler(File file) {
        AbstractContentHandler result = null;
        String ext = FileUtils.getExtension(file);
        if (ext == null) {
            return result;
        }
        ext = ext.toLowerCase();
        Properties props = PreviewBrowserPanel.getProperties();
        if (props.hasKey(PREFIX_PREFERRED_CONTENT_HANDLER + ext)) {
            String handler = props.getProperty(PREFIX_PREFERRED_CONTENT_HANDLER + ext);
            try {
                result = (AbstractContentHandler)Class.forName(handler).newInstance();
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate handler: " + handler);
                e.printStackTrace();
            }
        }
        return result;
    }

    protected void updatePreferredContentHandler() {
        if (this.m_CurrentFile == null) {
            return;
        }
        String ext = FileUtils.getExtension(this.m_CurrentFile);
        if (ext == null) {
            return;
        }
        ext = ext.toLowerCase();
        String handler = this.m_ComboBoxContentHandlers.getSelectedIndex() < 0 ? (String)this.m_ComboBoxContentHandlers.getItemAt(0) : (String)this.m_ComboBoxContentHandlers.getSelectedItem();
        Properties props = PreviewBrowserPanel.getProperties();
        props.setProperty(PREFIX_PREFERRED_CONTENT_HANDLER + ext, handler);
        String filename = Environment.getInstance().getHome() + File.separator + FILENAME;
        if (!props.save(filename)) {
            System.err.println("Failed to save properties to '" + filename + "'!");
        }
    }

    protected AbstractArchiveHandler getPreferredArchiveHandler(File file) {
        AbstractArchiveHandler result = null;
        String ext = FileUtils.getExtension(file);
        if (ext == null) {
            return result;
        }
        ext = ext.toLowerCase();
        Properties props = PreviewBrowserPanel.getProperties();
        if (props.hasKey(PREFIX_PREFERRED_ARCHIVE_HANDLER + ext)) {
            String handler = props.getProperty(PREFIX_PREFERRED_ARCHIVE_HANDLER + ext);
            try {
                result = (AbstractArchiveHandler)Class.forName(handler).newInstance();
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate handler: " + handler);
                e.printStackTrace();
            }
        }
        return result;
    }

    protected void updatePreferredArchiveHandler() {
        if (this.m_CurrentFile == null) {
            return;
        }
        String ext = FileUtils.getExtension(this.m_CurrentFile);
        if (ext == null) {
            return;
        }
        ext = ext.toLowerCase();
        String handler = this.m_ComboBoxArchiveHandlers.getSelectedIndex() < 0 ? (String)this.m_ComboBoxArchiveHandlers.getItemAt(0) : (String)this.m_ComboBoxArchiveHandlers.getSelectedItem();
        Properties props = PreviewBrowserPanel.getProperties();
        props.setProperty(PREFIX_PREFERRED_ARCHIVE_HANDLER + ext, handler);
        String filename = Environment.getInstance().getCustomPropertiesFilename("preview browser");
        if (!Environment.getInstance().write("preview browser", props)) {
            System.err.println("Failed to save properties to '" + filename + "'!");
        }
    }

    public static synchronized Properties getProperties() {
        if (m_Properties == null) {
            m_Properties = Environment.getInstance().read("preview browser");
        }
        return m_Properties;
    }
}

