/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.container;

import adams.core.Properties;
import adams.data.container.DataContainer;
import adams.gui.core.BaseSplitPane;
import adams.gui.visualization.container.ContainerManager;
import adams.gui.visualization.container.DataContainerPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataContainerPanelWithSidePanel<T extends DataContainer, M extends ContainerManager>
extends DataContainerPanel<T, M> {
    private static final long serialVersionUID = -2596192201610436582L;
    protected BaseSplitPane m_SplitPane;
    protected boolean m_FirstRevalidate;
    protected JPanel m_SidePanel;

    public DataContainerPanelWithSidePanel() {
    }

    public DataContainerPanelWithSidePanel(String title) {
        super(title);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_FirstRevalidate = true;
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        Properties props = this.getProperties();
        this.m_SidePanel = new JPanel(new BorderLayout());
        this.m_SidePanel.setPreferredSize(new Dimension(props.getInteger("Plot.SidePanelWidth", 150), 0));
        this.m_SidePanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.m_SplitPane = new BaseSplitPane(1);
        this.m_SplitPane.setLeftComponent(this.m_PlotPanel);
        this.m_SplitPane.setRightComponent(this.m_SidePanel);
        this.m_SplitPane.setResizeWeight(1.0);
        this.m_SplitPane.setOneTouchExpandable(true);
        this.remove(this.m_PlotPanel);
        this.add((Component)this.m_SplitPane, "Center");
    }

    public void setSidePanelVisible(boolean visible) {
        if (visible) {
            this.remove(this.m_PlotPanel);
            this.add((Component)this.m_SplitPane, "Center");
            this.m_SplitPane.setLeftComponent(this.m_PlotPanel);
            this.m_SplitPane.setRightComponent(this.m_SidePanel);
        } else {
            this.remove(this.m_SplitPane);
            this.add((Component)this.m_PlotPanel, "Center");
        }
        this.m_SidePanel.setVisible(visible);
        if (this.getParent() != null) {
            this.getParent().invalidate();
            this.getParent().validate();
        } else {
            this.invalidate();
            this.validate();
        }
    }

    public boolean isSidePanelVisible() {
        return this.m_SidePanel.isVisible();
    }

    public JPanel getSidePanel() {
        return this.m_SidePanel;
    }

    @Override
    public void revalidate() {
        if (this.m_FirstRevalidate && this.m_SplitPane != null) {
            this.m_FirstRevalidate = false;
            this.m_SplitPane.resetToPreferredSizes();
        }
        super.revalidate();
    }

    public void setDividerLocation(int value) {
        this.m_SplitPane.setDividerLocation(value);
    }

    public void setDividerLocation(double value) {
        this.m_SplitPane.setDividerLocation(value);
    }

    public int getDividerLocation() {
        return this.m_SplitPane.getDividerLocation();
    }
}

