/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.core;

import adams.gui.visualization.core.AbstractColorGradientGenerator;
import java.awt.Color;

public class MultiColorGenerator
extends AbstractColorGradientGenerator {
    private static final long serialVersionUID = 3344443413467944112L;
    protected int m_NumColors;
    protected Color[] m_Colors;

    public String globalInfo() {
        return "Generates gradient colors between multiple colors.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-colors", "numColors", 255, 1, null);
        this.m_OptionManager.add("color", "colors", new Color[]{Color.BLUE.darker(), Color.GREEN.darker(), Color.RED.darker(), Color.YELLOW});
    }

    public void setNumColors(int value) {
        this.m_NumColors = value;
        this.reset();
    }

    public int getNumColors() {
        return this.m_NumColors;
    }

    public String numColorsTipText() {
        return "The number of colors in the gradient to use.";
    }

    public void setColors(Color[] value) {
        this.m_Colors = value;
        this.reset();
    }

    public Color[] getColors() {
        return this.m_Colors;
    }

    public String colorsTipText() {
        return "The colors to use for the gradient.";
    }

    protected void check() {
        super.check();
        if (this.m_Colors.length < 2) {
            throw new IllegalStateException("At least two colors must be defined!");
        }
        for (int i = 1; i < this.m_Colors.length; ++i) {
            if (!this.m_Colors[i - 1].equals(this.m_Colors[i])) continue;
            throw new IllegalStateException("The consecutive colors #" + i + " and " + (i + 1) + " are the same!");
        }
    }

    protected Color[] doGenerate() {
        Color[] result = new Color[this.m_NumColors];
        double step = (double)(this.m_Colors.length - 1) / (double)this.m_NumColors;
        int count = 0;
        for (int i = 1; i < this.m_Colors.length; ++i) {
            boolean next;
            int red1 = this.m_Colors[i - 1].getRed();
            int green1 = this.m_Colors[i - 1].getGreen();
            int blue1 = this.m_Colors[i - 1].getBlue();
            int red2 = this.m_Colors[i].getRed();
            int green2 = this.m_Colors[i].getGreen();
            int blue2 = this.m_Colors[i].getBlue();
            int n = 0;
            do {
                int redNew = (int)((double)red1 + (double)(red2 < red1 ? -n : n) * step * (double)Math.abs(red2 - red1));
                int greenNew = (int)((double)green1 + (double)(green2 < green1 ? -n : n) * step * (double)Math.abs(green2 - green1));
                int blueNew = (int)((double)blue1 + (double)(blue2 < blue1 ? -n : n) * step * (double)Math.abs(blue2 - blue1));
                result[count] = new Color(redNew, greenNew, blueNew);
                next = red1 < red2 && redNew >= red2 || red1 > red2 && redNew <= red2 || green1 < green2 && greenNew >= green2 || green1 > green2 && greenNew <= green2 || blue1 < blue2 && blueNew >= blue2 || blue1 > blue2 && blueNew <= blue2;
                ++n;
            } while (++count < this.m_NumColors && !next);
        }
        return result;
    }
}

