/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.core;

import adams.gui.core.BasePanel;
import adams.gui.event.PaintEvent;
import adams.gui.event.PaintListener;
import adams.gui.visualization.core.AbstractPaintlet;
import adams.gui.visualization.core.PlotPanel;
import java.awt.Graphics;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PaintablePanel
extends BasePanel
implements PaintListener {
    private static final long serialVersionUID = -1394066820727332049L;
    protected HashSet<AbstractPaintlet> m_Paintlets;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Paintlets = new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPaintlet(AbstractPaintlet p) {
        HashSet<AbstractPaintlet> hashSet = this.m_Paintlets;
        synchronized (hashSet) {
            this.m_Paintlets.add(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePaintlet(AbstractPaintlet p) {
        HashSet<AbstractPaintlet> hashSet = this.m_Paintlets;
        synchronized (hashSet) {
            this.m_Paintlets.remove(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<AbstractPaintlet> paintlets() {
        HashSet<AbstractPaintlet> hashSet = this.m_Paintlets;
        synchronized (hashSet) {
            return this.m_Paintlets.iterator();
        }
    }

    public abstract PlotPanel getPlot();

    protected abstract void prepareUpdate();

    protected void performUpdate() {
        Runnable run = new Runnable(){

            public void run() {
                PaintablePanel.this.validate();
                PaintablePanel.this.repaint();
            }
        };
        SwingUtilities.invokeLater(run);
    }

    public synchronized void update() {
        this.prepareUpdate();
        this.performUpdate();
    }

    protected abstract boolean canPaint(Graphics var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paint(Graphics g, PaintEvent.PaintMoment moment) {
        HashSet<AbstractPaintlet> hashSet = this.m_Paintlets;
        synchronized (hashSet) {
            for (AbstractPaintlet paintlet : this.m_Paintlets) {
                if (paintlet.getPaintMoment() != moment) continue;
                paintlet.paint(g);
            }
        }
    }

    @Override
    public void painted(PaintEvent e) {
        Graphics g = e.getGraphics();
        if (!this.canPaint(g)) {
            return;
        }
        this.paint(g, e.getPaintMoment());
    }
}

