/*
 * Decompiled with CFR 0.152.
 */
package adams.multiprocess;

import adams.core.CleanUpHandler;
import adams.core.ConsoleObject;
import adams.event.JobCompleteEvent;
import adams.event.JobCompleteListener;
import adams.multiprocess.JobResult;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Job
extends ConsoleObject
implements CleanUpHandler {
    private static final long serialVersionUID = -4365906331615932775L;
    protected String m_jobInfo;
    protected Hashtable<String, Serializable> m_jobParams = new Hashtable();
    protected Vector<Job> m_depends = new Vector();
    protected boolean m_complete;
    protected JobCompleteListener m_completed;
    protected String m_ExecutionError;

    public Job() {
        this("");
    }

    public Job(String info) {
        this.m_jobInfo = info;
        this.m_complete = false;
        this.m_completed = null;
        this.m_ExecutionError = null;
    }

    public String getJobInfo() {
        return this.m_jobInfo;
    }

    public Vector<Job> getAsVector() {
        Vector<Job> vj = new Vector<Job>();
        vj.add(this);
        return vj;
    }

    public void jobCompleted(Job j, JobResult jr) {
        if (this.m_completed != null) {
            this.m_completed.jobCompleted(new JobCompleteEvent(this, j, jr));
        }
    }

    public void addDependency(Job j) {
        this.m_depends.add(j);
    }

    public Vector<Job> getDependencies() {
        return new Vector<Job>(this.m_depends);
    }

    public void addParam(String name, Serializable o) {
        this.m_jobParams.put(name, o);
    }

    public Serializable getParam(String name) {
        return this.m_jobParams.get(name);
    }

    public void setJobCompleteListener(JobCompleteListener l) {
        this.m_completed = l;
    }

    public JobCompleteListener getJobCompleteListener() {
        return this.m_completed;
    }

    public boolean isComplete() {
        return this.m_complete;
    }

    protected abstract String preProcessCheck();

    protected abstract void process();

    protected abstract String postProcessCheck();

    protected String getAdditionalErrorInformation() {
        return "";
    }

    public JobResult execute() {
        String addInfo;
        boolean success;
        this.m_ExecutionError = this.preProcessCheck();
        boolean bl = success = this.m_ExecutionError == null;
        if (!success) {
            this.m_ExecutionError = "'pre-check' failed: " + this.m_ExecutionError;
        }
        if (success) {
            try {
                this.process();
            }
            catch (Exception e) {
                StringWriter writer = new StringWriter();
                e.printStackTrace(new PrintWriter(writer));
                this.m_ExecutionError = "'process' failed with exception: " + writer.toString();
                success = false;
            }
        }
        if (success) {
            this.m_ExecutionError = this.postProcessCheck();
            boolean bl2 = success = this.m_ExecutionError == null;
            if (!success) {
                this.m_ExecutionError = "'post-check' failed: " + this.m_ExecutionError;
            }
        }
        if (!success && (addInfo = this.getAdditionalErrorInformation()).length() > 0) {
            this.m_ExecutionError = this.m_ExecutionError + "\n" + addInfo;
        }
        this.m_complete = true;
        JobResult result = new JobResult(success ? this.toString() : this.m_ExecutionError, success);
        return result;
    }

    public boolean hasExecutionError() {
        return this.m_ExecutionError != null;
    }

    public String getExecutionError() {
        return this.m_ExecutionError;
    }

    @Override
    public void cleanUp() {
        this.m_depends.clear();
        this.m_jobParams.clear();
    }

    public abstract String toString();
}

