/*
 * Decompiled with CFR 0.152.
 */
package adams.multiprocess;

import adams.core.Performance;
import adams.event.JobCompleteEvent;
import adams.event.JobCompleteListener;
import adams.event.JobCompleteManagerChangeEvent;
import adams.event.JobCompleteManagerChangeListener;
import adams.multiprocess.JobResult;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobCompleteManager
implements JobCompleteListener {
    private static final long serialVersionUID = 5145095894679891834L;
    protected static JobCompleteManager m_Singleton;
    protected Vector<JobCompleteInformation> m_Informations = new Vector();
    protected HashSet<JobCompleteManagerChangeListener> m_ChangeListeners = new HashSet();

    private JobCompleteManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() {
        Vector<JobCompleteInformation> vector = this.m_Informations;
        synchronized (vector) {
            this.m_Informations.clear();
        }
        this.notifyChangeListeners(new JobCompleteManagerChangeEvent(this, JobCompleteManagerChangeEvent.Type.RESET));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Vector<JobCompleteInformation> getInformations() {
        Vector<JobCompleteInformation> result;
        Vector<JobCompleteInformation> vector = this.m_Informations;
        synchronized (vector) {
            result = new Vector<JobCompleteInformation>();
            result.addAll(this.m_Informations);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void jobCompleted(JobCompleteEvent e) {
        if (Performance.getKeepOnlyFailedJobComplete() && e.getResult().getSuccess()) {
            return;
        }
        boolean reset = false;
        Vector<JobCompleteInformation> vector = this.m_Informations;
        synchronized (vector) {
            JobResult jr;
            this.m_Informations.add(new JobCompleteInformation(e));
            if (this.m_Informations.size() > Performance.getMaxKeepJobComplete()) {
                reset = true;
                Vector<JobCompleteInformation> informations = new Vector<JobCompleteInformation>(this.m_Informations.subList(this.m_Informations.size() - Performance.getMinKeepJobComplete(), this.m_Informations.size() - 1));
                this.m_Informations = informations;
            }
            if (!(jr = e.getResult()).getSuccess()) {
                System.err.println("Failed job:\n  " + e.getJob() + "\nwith message:\n  " + jr);
            }
        }
        if (reset) {
            this.notifyChangeListeners(new JobCompleteManagerChangeEvent(this, JobCompleteManagerChangeEvent.Type.RESET));
        } else {
            this.notifyChangeListeners(new JobCompleteManagerChangeEvent(this, JobCompleteManagerChangeEvent.Type.APPEND));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(JobCompleteManagerChangeListener l) {
        HashSet<JobCompleteManagerChangeListener> hashSet = this.m_ChangeListeners;
        synchronized (hashSet) {
            this.m_ChangeListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(JobCompleteManagerChangeListener l) {
        HashSet<JobCompleteManagerChangeListener> hashSet = this.m_ChangeListeners;
        synchronized (hashSet) {
            this.m_ChangeListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyChangeListeners(JobCompleteManagerChangeEvent e) {
        HashSet<JobCompleteManagerChangeListener> hashSet = this.m_ChangeListeners;
        synchronized (hashSet) {
            Iterator<JobCompleteManagerChangeListener> iter = this.m_ChangeListeners.iterator();
            while (iter.hasNext()) {
                iter.next().stateChanged(e);
            }
        }
    }

    public static synchronized JobCompleteManager getSingleton() {
        if (m_Singleton == null) {
            m_Singleton = new JobCompleteManager();
        }
        return m_Singleton;
    }

    public static class JobCompleteInformation {
        protected String m_JobClass;
        protected String m_JobDetails;
        protected JobResult m_JobResult;

        public JobCompleteInformation(JobCompleteEvent event) {
            this.m_JobClass = event.getJob().getClass().getName();
            this.m_JobDetails = event.getJob().toString();
            this.m_JobResult = event.getResult();
        }

        public String getJobClass() {
            return this.m_JobClass;
        }

        public String getJobDetails() {
            return this.m_JobDetails;
        }

        public JobResult getJobResult() {
            return this.m_JobResult;
        }
    }
}

