/*
 * Decompiled with CFR 0.152.
 */
package adams.optimise;

import adams.core.CloneHandler;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptVar
implements Serializable,
CloneHandler<OptVar> {
    private static final long serialVersionUID = 8200214909919052160L;
    public String m_name;
    public double m_max;
    public double m_min;
    public boolean m_isInteger;

    public OptVar(String name, double min, double max, boolean isInteger) {
        this.m_max = max;
        this.m_min = min;
        this.m_name = name;
        this.m_isInteger = isInteger;
    }

    public OptVar(String name, double min, double max) {
        this.m_max = max;
        this.m_min = min;
        this.m_name = name;
        this.m_isInteger = false;
    }

    @Override
    public OptVar getClone() {
        return new OptVar(this.m_name, this.m_min, this.m_max, this.m_isInteger);
    }

    public int getSteps(int numSplits) {
        if (this.m_isInteger && (double)numSplits > Math.abs(this.m_max - this.m_min + 1.0)) {
            return (int)Math.abs(this.m_max - this.m_min + 1.0);
        }
        return numSplits;
    }

    public double getStepSize(int numSplits) {
        if (this.m_isInteger && (double)numSplits > Math.abs(this.m_max - this.m_min)) {
            return 1.0;
        }
        return Math.abs(this.m_max - this.m_min) / (double)(numSplits - 1);
    }

    public String toString() {
        return "min=" + this.m_min + ",max=" + this.m_max;
    }
}

