/*
 * Decompiled with CFR 0.152.
 */
package adams.data.imagej.flattener;

import adams.data.imagej.Image;
import adams.data.imagej.flattener.AbstractImageJFlattener;
import weka.core.Instance;
import weka.core.Instances;

public class NamedSetup
extends AbstractImageJFlattener {
    private static final long serialVersionUID = -3442872825798982018L;
    protected adams.core.NamedSetup m_Setup;
    protected AbstractImageJFlattener m_ActualScheme;

    public String globalInfo() {
        return "Applies an ImageJ flattener that is referenced via its global setup name (see 'NamedSetups').";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("setup", "setup", (Object)new adams.core.NamedSetup());
    }

    public void reset() {
        super.reset();
        this.m_ActualScheme = null;
    }

    public void setSetup(adams.core.NamedSetup value) {
        this.m_Setup = value;
        if (!this.m_Setup.isDummy() && !this.m_Setup.exists()) {
            this.getSystemErr().println("Warning: named setup '" + this.m_Setup + "' unknown!");
        }
        this.reset();
    }

    public adams.core.NamedSetup getSetup() {
        return this.m_Setup;
    }

    public String setupTipText() {
        return "The name of the setup to use.";
    }

    protected AbstractImageJFlattener getActualScheme() {
        if (this.m_ActualScheme == null) {
            this.m_ActualScheme = (AbstractImageJFlattener)this.m_Setup.getSetup();
            if (this.m_ActualScheme == null) {
                throw new IllegalStateException("Failed to instantiate named setup '" + this.m_Setup + "'!");
            }
        }
        return this.m_ActualScheme;
    }

    protected Instances createHeader(Image img) {
        return this.getActualScheme().createHeader(img);
    }

    protected Instance doFlatten(Image img) {
        return this.getActualScheme().flatten(img);
    }
}

