/*
 * Decompiled with CFR 0.152.
 */
package adams.data.jai.flattener;

import adams.data.jai.flattener.AbstractJAIFlattener;
import java.awt.image.BufferedImage;
import weka.core.Instance;
import weka.core.Instances;

public class NamedSetup
extends AbstractJAIFlattener {
    private static final long serialVersionUID = -3442872825798982018L;
    protected adams.core.NamedSetup m_Setup;
    protected AbstractJAIFlattener m_ActualScheme;

    public String globalInfo() {
        return "Applies a JAI flattener that is referenced via its global setup name (see 'NamedSetups').";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("setup", "setup", (Object)new adams.core.NamedSetup());
    }

    public void reset() {
        super.reset();
        this.m_ActualScheme = null;
    }

    public void setSetup(adams.core.NamedSetup value) {
        this.m_Setup = value;
        if (!this.m_Setup.isDummy() && !this.m_Setup.exists()) {
            this.getSystemErr().println("Warning: named setup '" + this.m_Setup + "' unknown!");
        }
        this.reset();
    }

    public adams.core.NamedSetup getSetup() {
        return this.m_Setup;
    }

    public String setupTipText() {
        return "The name of the setup to use.";
    }

    protected AbstractJAIFlattener getActualScheme() {
        if (this.m_ActualScheme == null) {
            this.m_ActualScheme = (AbstractJAIFlattener)this.m_Setup.getSetup();
            if (this.m_ActualScheme == null) {
                throw new IllegalStateException("Failed to instantiate named setup '" + this.m_Setup + "'!");
            }
        }
        return this.m_ActualScheme;
    }

    protected Instances createHeader(BufferedImage img) {
        return this.getActualScheme().createHeader(img);
    }

    protected Instance doFlatten(BufferedImage img) {
        return this.getActualScheme().flatten(img);
    }
}

