/*
 * Decompiled with CFR 0.152.
 */
package adams.data.jai.transformer;

import adams.core.BufferedImageHelper;
import adams.core.ClassLister;
import adams.core.CleanUpHandler;
import adams.core.JAIHelper;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionHandler;
import adams.core.option.OptionHandlingObject;
import adams.core.option.OptionUtils;
import java.awt.image.BufferedImage;

public abstract class AbstractJAITransformer
extends OptionHandlingObject
implements Comparable,
CleanUpHandler {
    private static final long serialVersionUID = 6509685876509009633L;

    protected void checkImage(BufferedImage img) {
        if (img == null) {
            throw new IllegalStateException("No image provided!");
        }
    }

    protected abstract BufferedImage[] doTransform(BufferedImage var1);

    public BufferedImage[] transform(BufferedImage img) {
        this.checkImage(img);
        BufferedImage[] result = this.doTransform(BufferedImageHelper.deepCopy(img));
        return result;
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        return OptionUtils.getCommandLine((Object)this).compareTo(OptionUtils.getCommandLine((Object)o));
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public AbstractJAITransformer shallowCopy() {
        return this.shallowCopy(false);
    }

    public AbstractJAITransformer shallowCopy(boolean expand) {
        return (AbstractJAITransformer)OptionUtils.shallowCopy((OptionHandler)this, (boolean)expand);
    }

    public void cleanUp() {
    }

    public void destroy() {
        this.cleanUp();
        super.destroy();
    }

    public static String[] getTransformations() {
        return ClassLister.getSingleton().getClassnames(AbstractJAITransformer.class);
    }

    public static AbstractJAITransformer forName(String classname, String[] options) {
        AbstractJAITransformer result;
        try {
            result = (AbstractJAITransformer)OptionUtils.forName(AbstractJAITransformer.class, (String)classname, (String[])options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static AbstractJAITransformer forCommandLine(String cmdline) {
        return (AbstractJAITransformer)AbstractOptionConsumer.fromString(ArrayConsumer.class, (String)cmdline);
    }

    static {
        JAIHelper.disableMediaLib();
    }
}

