/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.data.statistics.StatUtils;
import adams.flow.core.Token;
import adams.flow.source.AbstractSource;
import adams.flow.standalone.RServe;

public class RSource
extends AbstractSource {
    private static final long serialVersionUID = -3064162887434390818L;
    protected String m_rScript;
    protected DataType m_returnType;
    protected Object m_returnedObject;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("r-Script", "rScript", (Object)"");
        this.m_OptionManager.add("return-type", "returnType", (Object)DataType.Integer);
    }

    public void setReturnType(DataType val) {
        this.m_returnType = val;
        this.reset();
    }

    public DataType getReturnType() {
        return this.m_returnType;
    }

    public String returnTypeTipText() {
        return "Data type of returned object";
    }

    public void setRScript(String val) {
        this.m_rScript = val;
        this.reset();
    }

    public String getRScript() {
        return this.m_rScript;
    }

    public String rScriptTipText() {
        return "Script to pass into r";
    }

    public Class[] generates() {
        Class[] generated = new Class[]{};
        switch (this.m_returnType) {
            case Integer: {
                generated = new Class[]{Integer.class};
                break;
            }
            case IntArray: {
                generated = new Class[]{Integer[].class};
                break;
            }
            case Int2DArray: {
                generated = new Class[]{Integer[][].class};
                break;
            }
            case String: {
                generated = new Class[]{String.class};
                break;
            }
            case StrArray: {
                generated = new Class[]{String[].class};
                break;
            }
            case Str2DArray: {
                generated = new Class[]{Integer[][].class};
                break;
            }
            case Double: {
                generated = new Class[]{Double.class};
                break;
            }
            case DubArray: {
                generated = new Class[]{Double[].class};
                break;
            }
            default: {
                generated = new Class[]{Double[][].class};
            }
        }
        return generated;
    }

    public Token output() {
        Token result = new Token(this.m_returnedObject);
        this.m_returnedObject = null;
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_returnedObject != null;
    }

    protected String doExecute() {
        RServe rs = new RServe();
        double[] dbl = (double[])rs.doRequest(this.m_rScript);
        this.m_returnedObject = StatUtils.toNumberArray((double[])dbl);
        return null;
    }

    public String globalInfo() {
        return "Carries out an R function on the input script";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataType {
        Integer,
        IntArray,
        Int2DArray,
        Double,
        DubArray,
        Dub2DArray,
        String,
        StrArray,
        Str2DArray;

    }
}

