/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.core.io.PdfFont;
import adams.env.Environment;
import adams.gui.chooser.PdfFontChooserPanel;
import adams.gui.core.BaseDialog;
import adams.gui.core.BaseFrame;
import adams.gui.goe.PdfFontEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PdfFontChooser
extends BaseDialog {
    private static final long serialVersionUID = 4228582248866956387L;
    protected PdfFontChooserPanel m_FontPanel;
    protected JButton m_ButtonOK;
    protected JButton m_ButtonCancel;
    protected PdfFont m_Current;

    public PdfFontChooser(Frame owner) {
        super(owner, "PDF Font Chooser", true);
    }

    public PdfFontChooser(Dialog owner) {
        super(owner, "PDF Font Chooser", Dialog.ModalityType.DOCUMENT_MODAL);
    }

    protected void initGUI() {
        super.initGUI();
        this.getContentPane().setLayout(new BorderLayout());
        this.m_FontPanel = new PdfFontChooserPanel();
        this.getContentPane().add((Component)((Object)this.m_FontPanel), "Center");
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        this.m_ButtonOK = new JButton("OK");
        this.m_ButtonOK.setMnemonic('O');
        panelButtons.add(this.m_ButtonOK);
        this.m_ButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PdfFontChooser.this.m_Current = PdfFontChooser.this.m_FontPanel.getCurrent();
                PdfFontChooser.this.dispose();
                PdfFontChooser.this.setVisible(false);
            }
        });
        this.m_ButtonCancel = new JButton("Cancel");
        this.m_ButtonCancel.setMnemonic('C');
        panelButtons.add(this.m_ButtonCancel);
        this.m_ButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PdfFontChooser.this.m_FontPanel.setCurrent(PdfFontChooser.this.m_Current);
                PdfFontChooser.this.dispose();
                PdfFontChooser.this.setVisible(false);
            }
        });
        this.getContentPane().add((Component)panelButtons, "South");
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public void setCurrent(PdfFont value) {
        this.m_Current = value;
        this.m_FontPanel.setCurrent(this.m_Current);
    }

    public PdfFont getCurrent() {
        return this.m_Current;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        final BaseFrame frame = new BaseFrame("PdfFontChooser Startup");
        final PdfFontChooser chooser = new PdfFontChooser((Frame)frame);
        chooser.setCurrent(null);
        frame.getContentPane().setLayout(new GridLayout(0, 1));
        JButton button = new JButton("Change font");
        frame.getContentPane().add(button);
        final JLabel label = new JLabel("Java is great!", 0);
        frame.getContentPane().add(label);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                chooser.setVisible(true);
                PdfFont myNewFont = chooser.getCurrent();
                System.out.println("You chose " + PdfFontEditor.toString(null, myNewFont));
                label.setFont(myNewFont.toJavaFont());
                frame.pack();
                chooser.dispose();
            }
        });
        frame.setSize(150, 100);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }
}

