/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.bytematrix.impl;

import org.ujmp.core.Matrix;
import org.ujmp.core.bytematrix.stub.AbstractDenseByteMatrix2D;
import org.ujmp.core.exceptions.MatrixException;

public class ArrayDenseByteMatrix2D
extends AbstractDenseByteMatrix2D {
    private static final long serialVersionUID = 1111734188254187991L;
    private byte[][] values = null;

    public ArrayDenseByteMatrix2D(Matrix m) throws MatrixException {
        if (m instanceof ArrayDenseByteMatrix2D) {
            byte[][] v = ((ArrayDenseByteMatrix2D)m).values;
            this.values = new byte[v.length][v[0].length];
            int r = v.length;
            while (--r >= 0) {
                int c = v[0].length;
                while (--c >= 0) {
                    this.values[r][c] = v[r][c];
                }
            }
        } else {
            this.values = new byte[(int)m.getRowCount()][(int)m.getColumnCount()];
            for (long[] c : m.allCoordinates()) {
                this.setAsByte(m.getAsByte(c), c);
            }
        }
    }

    public ArrayDenseByteMatrix2D(byte[] ... v) {
        this.values = v;
    }

    public ArrayDenseByteMatrix2D(long ... size) {
        this.values = new byte[(int)size[0]][(int)size[1]];
    }

    public ArrayDenseByteMatrix2D(byte[] v) {
        this.values = new byte[v.length][1];
        int r = v.length;
        while (--r >= 0) {
            this.values[r][0] = v[r];
        }
    }

    public long[] getSize() {
        return new long[]{this.values.length, this.values.length == 0 ? 0 : this.values[0].length};
    }

    public long getRowCount() {
        return this.values.length;
    }

    public long getColumnCount() {
        return this.values.length == 0 ? 0 : this.values[0].length;
    }

    public byte getByte(long row, long column) {
        return this.values[(int)row][(int)column];
    }

    public void setByte(byte value, long row, long column) {
        this.values[(int)row][(int)column] = value;
    }

    public byte getByte(int row, int column) {
        return this.values[row][column];
    }

    public void setByte(byte value, int row, int column) {
        this.values[row][column] = value;
    }

    public final Matrix transpose() {
        byte[][] result = new byte[this.values[0].length][this.values.length];
        int r = result.length;
        while (--r >= 0) {
            int c = result[0].length;
            while (--c >= 0) {
                result[r][c] = this.values[c][r];
            }
        }
        return new ArrayDenseByteMatrix2D(result);
    }
}

