/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.impl;

import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.stub.AbstractDenseDoubleMatrix;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.util.MathUtil;

public class DefaultDenseDoubleMatrixMultiD
extends AbstractDenseDoubleMatrix {
    private static final long serialVersionUID = 2875235320924485070L;
    private double[] values = null;
    private long[] size = null;
    private int length = 0;

    public DefaultDenseDoubleMatrixMultiD(Matrix m) throws MatrixException {
        this.size = Coordinates.copyOf(m.getSize());
        this.length = (int)Coordinates.product(this.size);
        this.values = new double[this.length];
        if (m instanceof DefaultDenseDoubleMatrixMultiD) {
            double[] v = ((DefaultDenseDoubleMatrixMultiD)m).values;
            System.arraycopy(v, 0, this.values, 0, v.length);
        } else {
            for (long[] c : m.allCoordinates()) {
                this.setDouble(m.getAsDouble(c), c);
            }
        }
    }

    public DefaultDenseDoubleMatrixMultiD(long ... size) {
        this.size = Coordinates.copyOf(size);
        this.length = (int)Coordinates.product(size);
        this.values = new double[this.length];
    }

    public DefaultDenseDoubleMatrixMultiD(double[] v, long ... size) {
        this.size = Coordinates.copyOf(size);
        this.length = (int)Coordinates.product(size);
        this.values = v;
    }

    public final long[] getSize() {
        return this.size;
    }

    public final double getDouble(long ... pos) {
        return this.values[(int)MathUtil.pos2IndexRowMajor(this.size, pos)];
    }

    public final void setDouble(double value, long ... pos) {
        this.values[(int)MathUtil.pos2IndexRowMajor((long[])this.size, (long[])pos)] = value;
    }
}

