/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.paintlet;

import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.stats.paintlet.AbstractColorPaintlet;
import java.awt.Color;
import java.awt.Graphics;

public class HistogramPaintlet
extends AbstractColorPaintlet {
    private static final long serialVersionUID = -3474738819482043957L;
    protected AxisPanel m_AxisLeft;
    protected AxisPanel m_AxisBottom;
    protected int m_NumBins;
    protected double m_BinWidth;
    protected double[][] m_Data;
    protected String m_Name;
    protected boolean m_Fill;
    protected Color m_FillColor;

    public PaintEvent.PaintMoment getPaintMoment() {
        return PaintEvent.PaintMoment.PAINT;
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("fill-bins", "fillBins", (Object)true);
        this.m_OptionManager.add("fill-color", "fillColor", (Object)Color.RED);
    }

    public void setFillBins(boolean val) {
        this.m_Fill = val;
        this.memberChanged();
    }

    public boolean getFillBins() {
        return this.m_Fill;
    }

    public String fillBinsTipText() {
        return "Fill the bins with color";
    }

    public void setFillColor(Color val) {
        this.m_FillColor = val;
        this.memberChanged();
    }

    public Color getFillColor() {
        return this.m_FillColor;
    }

    public String fillColorTipText() {
        return "color for filling the bins";
    }

    public void performPaint(Graphics g) {
        if (this.m_Data != null) {
            int i;
            this.m_AxisBottom = this.getPanel().getPlot().getAxis(Axis.BOTTOM);
            this.m_AxisLeft = this.getPanel().getPlot().getAxis(Axis.LEFT);
            this.m_AxisBottom.setNthValueToShow(this.m_Data.length / 5);
            this.m_AxisBottom.setMinimum(this.m_Data[0][0]);
            this.m_AxisBottom.setMaximum(this.m_Data[this.m_Data.length - 1][0] + this.m_BinWidth);
            this.m_AxisBottom.setAxisName(this.m_Name);
            this.m_AxisBottom.setNumTicks(this.m_Data.length);
            this.m_AxisLeft.setMinimum(0.0);
            double max = this.m_Data[1][0];
            for (i = 1; i < this.m_Data.length; ++i) {
                if (!(this.m_Data[i][1] > max)) continue;
                max = this.m_Data[i][1];
            }
            this.m_AxisLeft.setMaximum(max / this.m_BinWidth);
            this.m_AxisLeft.setAxisName("Frequency");
            for (i = 0; i < this.m_Data.length; ++i) {
                double val = this.m_Data[i][1] / this.m_BinWidth;
                if (this.m_Fill) {
                    g.setColor(this.m_FillColor);
                    g.fillRect(this.m_AxisBottom.valueToPos(this.m_Data[i][0]), this.m_AxisLeft.valueToPos(val), this.m_AxisBottom.valueToPos(this.m_Data[i][0] + this.m_BinWidth) - this.m_AxisBottom.valueToPos(this.m_Data[i][0]), this.m_AxisLeft.valueToPos(this.m_AxisLeft.getMinimum()) - this.m_AxisLeft.valueToPos(val));
                }
                g.setColor(this.m_Color);
                g.drawRect(this.m_AxisBottom.valueToPos(this.m_Data[i][0]), this.m_AxisLeft.valueToPos(val), this.m_AxisBottom.valueToPos(this.m_Data[i][0] + this.m_BinWidth) - this.m_AxisBottom.valueToPos(this.m_Data[i][0]), this.m_AxisLeft.valueToPos(this.m_AxisLeft.getMinimum()) - this.m_AxisLeft.valueToPos(val));
            }
        }
    }

    public String globalInfo() {
        return "Paints the histogram";
    }

    public void setNumBins(int val) {
        this.m_NumBins = val;
        this.memberChanged();
    }

    public void setData(double[][] data, double binWidth, String name) {
        this.m_Data = data;
        this.m_BinWidth = binWidth;
        this.m_Name = name;
        this.memberChanged();
    }
}

