/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.paintlet;

import adams.gui.core.GUIHelper;
import adams.gui.visualization.core.AntiAliasingPaintlet;
import adams.gui.visualization.stats.core.Point;
import adams.gui.visualization.stats.paintlet.AbstractOverlayPaintlet;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Collections;

public class LowessPaintlet
extends AbstractOverlayPaintlet
implements AntiAliasingPaintlet {
    private static final long serialVersionUID = 1643339689654875242L;
    private int m_WindowSize;
    protected ArrayList<Point> m_ToPlot;
    protected boolean m_AntiAliasingEnabled;

    public String globalInfo() {
        return "Paintlet for drawing the lowess overlay.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("window-size", "windowSize", (Object)100, (Number)1, null);
        this.m_OptionManager.add("anti-aliasing-enabled", "antiAliasingEnabled", (Object)GUIHelper.getBoolean(((Object)((Object)this)).getClass(), (String)"antiAliasingEnabled", (Boolean)true));
    }

    public void setWindowSize(int val) {
        this.m_WindowSize = val;
        this.memberChanged();
    }

    public int getWindowSize() {
        return this.m_WindowSize;
    }

    public String windowSizeTipText() {
        return "The window size for smoothing.";
    }

    public void setAntiAliasingEnabled(boolean value) {
        this.m_AntiAliasingEnabled = value;
        this.memberChanged();
    }

    public boolean isAntiAliasingEnabled() {
        return this.m_AntiAliasingEnabled;
    }

    public String antiAliasingEnabledTipText() {
        return "If enabled, uses anti-aliasing for drawing lines.";
    }

    public void calculate() {
        super.calculate();
        double[] x_data = this.m_Instances.attributeToDoubleArray(this.m_XInd);
        double[] y_data = this.m_Instances.attributeToDoubleArray(this.m_YInd);
        ArrayList<Point> points = new ArrayList<Point>();
        for (int i = 0; i < x_data.length; ++i) {
            Point p = new Point(x_data[i], y_data[i]);
            points.add(p);
        }
        Collections.sort(points);
        this.m_ToPlot = new ArrayList();
        if (this.m_WindowSize > points.size()) {
            this.m_WindowSize = points.size();
            System.out.println("Window size changed to number of points");
        }
        for (int i = 0; i < points.size(); ++i) {
            ArrayList closest = new ArrayList();
            closest.add(points.get(i));
            double ref = ((Point)points.get(i)).getX();
            int left = i - 1;
            int right = i + 1;
            for (int index = 1; index < this.m_WindowSize; ++index) {
                if (left < 0) {
                    closest.add(points.get(right));
                    ++right;
                    continue;
                }
                if (right > points.size() - 1) {
                    closest.add(points.get(left));
                    --left;
                    continue;
                }
                if (Math.abs(((Point)points.get(right)).getX() - ref) < Math.abs(((Point)points.get(left)).getX() - ref)) {
                    closest.add(points.get(right));
                    ++right;
                    continue;
                }
                closest.add(points.get(left));
                --left;
            }
            double max = Math.abs(((Point)closest.get(this.m_WindowSize - 1)).getX() - ref);
            double[] relDist = new double[closest.size()];
            for (int j = 0; j < closest.size(); ++j) {
                relDist[j] = Math.abs(((Point)closest.get(j)).getX() - ref) / max;
            }
            double[] weighting = new double[relDist.length];
            for (int j = 0; j < relDist.length; ++j) {
                weighting[j] = Math.pow(1.0 - Math.pow(relDist[j], 3.0), 3.0);
            }
            double sumWts = 0.0;
            double sumWtX = 0.0;
            double sumWtX2 = 0.0;
            double sumWtY = 0.0;
            double sumWtXY = 0.0;
            for (int j = 0; j < weighting.length; ++j) {
                sumWts += weighting[j];
                sumWtX += weighting[j] * ((Point)closest.get(j)).getX();
                sumWtX2 += weighting[j] * Math.pow(((Point)closest.get(j)).getX(), 2.0);
                sumWtY += weighting[j] * ((Point)closest.get(j)).getY();
                sumWtXY += weighting[j] * ((Point)closest.get(j)).getY() * ((Point)closest.get(j)).getX();
            }
            double denom = sumWts * sumWtX2 - Math.pow(sumWtX, 2.0);
            double slope = (sumWts * sumWtXY - sumWtX * sumWtY) / denom;
            double intercept = (sumWtX2 * sumWtY - sumWtX * sumWtXY) / denom;
            double val = slope * ((Point)closest.get(0)).getX() + intercept;
            this.m_ToPlot.add(new Point(((Point)closest.get(0)).getX(), val));
        }
        this.m_Calculated = true;
    }

    protected void drawData(Graphics g) {
        if (this.m_Calculated) {
            if (this.m_AntiAliasingEnabled) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            g.setColor(this.m_Color);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setStroke(new BasicStroke(this.m_StrokeThickness));
            for (int i = 0; i < this.m_ToPlot.size() - 1; ++i) {
                g2d.drawLine(this.m_AxisBottom.valueToPos(this.m_ToPlot.get(i).getX()), this.m_AxisLeft.valueToPos(this.m_ToPlot.get(i).getY()), this.m_AxisBottom.valueToPos(this.m_ToPlot.get(i + 1).getX()), this.m_AxisLeft.valueToPos(this.m_ToPlot.get(i + 1).getY()));
            }
        }
    }
}

