/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.paintlet;

import adams.gui.visualization.stats.paintlet.AbstractScatterPlotPaintlet;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class ScatterPaintletCross
extends AbstractScatterPlotPaintlet {
    private static final long serialVersionUID = -2415716946174098645L;

    public String globalInfo() {
        return "Class for plotting data on a scatter plot as crosses.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("size", "size", (Object)5, (Number)1, null);
    }

    public void setSize(int val) {
        this.m_Size = val;
        this.memberChanged();
    }

    public int getSize() {
        return this.m_Size;
    }

    public String sizeTipText() {
        return "The size of each data point.";
    }

    protected void drawData(Graphics g) {
        super.drawData(g);
        for (int i = 0; i < this.m_XData.length; ++i) {
            int posX = this.m_AxisBottom.valueToPos(this.m_XData[i]);
            int posY = this.m_AxisLeft.valueToPos(this.m_YData[i]);
            Graphics2D g2d = (Graphics2D)g;
            g.setColor(this.m_Color);
            g2d.setStroke(new BasicStroke(this.m_StrokeThickness));
            g2d.drawLine(posX - this.m_Size, posY - this.m_Size, posX + this.m_Size, posY + this.m_Size);
            g2d.drawLine(posX - this.m_Size, posY + this.m_Size, posX + this.m_Size, posY - this.m_Size);
        }
    }
}

