/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cos;

import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSDocumentElement;
import de.intarsys.pdf.cos.COSIndirectObject;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.ICOSContainer;
import de.intarsys.pdf.cos.ICOSObjectListener;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.attribute.IAttributeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class COSCompositeObject
extends COSObject
implements ICOSContainer,
IAttributeSupport {
    protected AttributeMap attributes;
    protected List objectListeners;

    protected COSCompositeObject() {
    }

    public void addObjectListener(ICOSObjectListener listener) {
        ArrayList<ICOSObjectListener> newListeners = this.objectListeners == null ? new ArrayList<ICOSObjectListener>() : new ArrayList(this.objectListeners);
        newListeners.add(listener);
        this.objectListeners = newListeners;
    }

    public ICOSContainer associate(ICOSContainer newContainer, COSObject object) {
        if (newContainer == this) {
            return this;
        }
        throw new IllegalStateException("object may only be contained once (use indirect object)");
    }

    public COSDocumentElement containable(COSObject object) {
        return object;
    }

    public final COSObject copyDeep() {
        return this.copyDeep(new HashMap());
    }

    public COSObject copyDeep(Map copied) {
        COSObject result = this.copyBasic();
        if (this.isIndirect()) {
            result.beIndirect();
            copied.put(this.getIndirectObject(), result);
        }
        return result;
    }

    public ICOSContainer disassociate(ICOSContainer oldContainer, COSObject object) {
        if (oldContainer == this) {
            object.basicSetContainer(COSObject.NULL_CONTAINER);
            return COSObject.NULL_CONTAINER;
        }
        throw new IllegalStateException("association inconsistent");
    }

    public synchronized Object getAttribute(Object key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.getAttribute(key);
    }

    public void harden(COSObject object) {
        this.container.harden(object);
    }

    public boolean isObjectListenerAvailable() {
        if (this.objectListeners == null) {
            return false;
        }
        return !this.objectListeners.isEmpty();
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean mayBeSwapped() {
        return true;
    }

    public int referenceCount() {
        return 1;
    }

    public COSIndirectObject referenceIndirect(COSObject object) {
        return COSIndirectObject.create(object);
    }

    public void register(COSDocumentElement object) {
        COSDocument doc = this.getDoc();
        if (doc != null) {
            object.registerWith(doc);
        }
    }

    protected void registerWith(COSDocument doc) {
        Iterator<COSDocumentElement> i = this.basicIterator();
        while (i.hasNext()) {
            COSDocumentElement element = i.next();
            element.registerWith(doc);
        }
    }

    public synchronized Object removeAttribute(Object key) {
        if (this.attributes != null) {
            this.attributes.removeAttribute(key);
        }
        return null;
    }

    public void removeObjectListener(ICOSObjectListener listener) {
        if (this.objectListeners == null) {
            return;
        }
        ArrayList newListeners = new ArrayList(this.objectListeners);
        newListeners.remove(listener);
        this.objectListeners = newListeners;
    }

    public ICOSContainer restoreStateContainer(ICOSContainer pContainer) {
        return pContainer;
    }

    public ICOSContainer saveStateContainer() {
        return this;
    }

    public synchronized Object setAttribute(Object key, Object value) {
        if (this.attributes == null) {
            this.attributes = new AttributeMap(1);
        }
        return this.attributes.setAttribute(key, value);
    }

    public void soften(COSObject object) {
        this.container.soften(object);
    }

    protected void triggerChanged(Object slot, Object oldValue, Object newValue) {
        if (this.objectListeners == null) {
            return;
        }
        for (ICOSObjectListener listener : this.objectListeners) {
            listener.changed(this, slot, oldValue, newValue);
        }
    }

    public void willChange(COSObject change) {
        this.container.willChange(change);
    }
}

