/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.crypt;

import de.intarsys.pdf.crypt.AccessPermissionsFull;
import de.intarsys.pdf.crypt.AccessPermissionsR3;
import de.intarsys.pdf.crypt.COSSecurityException;
import de.intarsys.pdf.crypt.IAccessPermissions;
import de.intarsys.pdf.crypt.StandardSecurityHandler;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class StandardSecurityHandlerR3
extends StandardSecurityHandler {
    public static final String CIPHER_ALGORITHM = "RC4";
    public static final String DIGEST_ALGORITHM = "MD5";
    public static final String KEY_ALGORITHM = "RC4";

    public boolean authenticateOwner(byte[] owner) throws COSSecurityException {
        try {
            byte[] preparedOwner = this.prepareBytes(owner);
            MessageDigest md = MessageDigest.getInstance(DIGEST_ALGORITHM);
            md.update(preparedOwner);
            byte[] key = md.digest();
            int length = this.getEncryption().getLength() / 8;
            int i = 0;
            while (i < 50) {
                md.update(key, 0, length);
                key = md.digest();
                ++i;
            }
            byte[] encryptionKey = new byte[length];
            System.arraycopy(key, 0, encryptionKey, 0, length);
            Cipher cipher = Cipher.getInstance("RC4");
            if (cipher == null) {
                throw new COSSecurityException("RC4 cipher not found");
            }
            byte[] encrypted = this.getO();
            byte[] tempEncKey = new byte[encryptionKey.length];
            int i2 = 19;
            while (i2 >= 0) {
                int index = 0;
                while (index < encryptionKey.length) {
                    tempEncKey[index] = (byte)(encryptionKey[index] ^ i2);
                    ++index;
                }
                SecretKeySpec skeySpec = new SecretKeySpec(tempEncKey, "RC4");
                cipher.init(2, skeySpec);
                encrypted = cipher.doFinal(encrypted);
                --i2;
            }
            if (this.authenticateUser(encrypted)) {
                this.setActiveAccessPermissions(AccessPermissionsFull.get());
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new COSSecurityException(e);
        }
    }

    public boolean authenticateUser(byte[] user) throws COSSecurityException {
        byte[] tempU;
        byte[] entryU = this.getU();
        if (entryU.length != (tempU = this.createUserPassword(user)).length) {
            return false;
        }
        int length = 16;
        int i = 0;
        while (i < length) {
            if (entryU[i] != tempU[i]) {
                return false;
            }
            ++i;
        }
        this.setCryptKey(this.createCryptKey(user));
        this.setActiveAccessPermissions(this.createAccessPermissions());
        return true;
    }

    protected IAccessPermissions createAccessPermissions() {
        return new AccessPermissionsR3(this.getPermissionFlags());
    }

    protected byte[] createCryptKey(byte[] password) throws COSSecurityException {
        try {
            MessageDigest md = MessageDigest.getInstance(DIGEST_ALGORITHM);
            byte[] prepared = this.prepareBytes(password);
            md.update(prepared);
            md.update(this.getO());
            md.update(this.getPBytes());
            byte[] fd = this.getPermanentFileID();
            if (fd != null) {
                md.update(fd);
            }
            byte[] key = md.digest();
            int length = this.getEncryption().getLength() / 8;
            int i = 0;
            while (i < 50) {
                md.update(key, 0, length);
                key = md.digest();
                ++i;
            }
            byte[] result = new byte[length];
            System.arraycopy(key, 0, result, 0, length);
            return result;
        }
        catch (Exception e) {
            throw new COSSecurityException(e);
        }
    }

    protected byte[] createOwnerPassword(byte[] owner, byte[] user) throws COSSecurityException {
        try {
            byte[] preparedOwner = owner == null ? this.prepareBytes(user) : this.prepareBytes(owner);
            MessageDigest md = MessageDigest.getInstance(DIGEST_ALGORITHM);
            md.update(preparedOwner);
            byte[] key = md.digest();
            int length = this.getEncryption().getLength() / 8;
            int i = 0;
            while (i < 50) {
                md.update(key, 0, length);
                key = md.digest();
                ++i;
            }
            byte[] encryptionKey = new byte[length];
            System.arraycopy(key, 0, encryptionKey, 0, length);
            SecretKeySpec skeySpec = new SecretKeySpec(encryptionKey, "RC4");
            byte[] preparedUser = this.prepareBytes(user);
            Cipher cipher = Cipher.getInstance("RC4");
            cipher.init(1, skeySpec);
            byte[] encrypted = cipher.doFinal(preparedUser);
            byte[] tempKey = new byte[encryptionKey.length];
            int i2 = 1;
            while (i2 <= 19) {
                int index = 0;
                while (index < encryptionKey.length) {
                    tempKey[index] = (byte)(encryptionKey[index] ^ i2);
                    ++index;
                }
                skeySpec = new SecretKeySpec(tempKey, "RC4");
                cipher.init(1, skeySpec);
                encrypted = cipher.doFinal(encrypted);
                ++i2;
            }
            return encrypted;
        }
        catch (Exception e) {
            throw new COSSecurityException(e);
        }
    }

    protected byte[] createUserPassword(byte[] user) throws COSSecurityException {
        try {
            byte[] encryptionKey = this.createCryptKey(user);
            MessageDigest md = MessageDigest.getInstance(DIGEST_ALGORITHM);
            md.update(PADDING);
            byte[] fd = this.getPermanentFileID();
            if (fd != null) {
                md.update(fd);
            }
            byte[] hash = md.digest();
            SecretKeySpec skeySpec = new SecretKeySpec(encryptionKey, "RC4");
            Cipher cipher = Cipher.getInstance("RC4");
            cipher.init(2, skeySpec);
            byte[] encrypted = cipher.doFinal(hash);
            byte[] tempEncKey = new byte[encryptionKey.length];
            int i = 1;
            while (i <= 19) {
                int index = 0;
                while (index < encryptionKey.length) {
                    tempEncKey[index] = (byte)(encryptionKey[index] ^ i);
                    ++index;
                }
                skeySpec = new SecretKeySpec(tempEncKey, "RC4");
                cipher.init(2, skeySpec);
                encrypted = cipher.doFinal(encrypted);
                ++i;
            }
            byte[] result = new byte[32];
            System.arraycopy(encrypted, 0, result, 0, 16);
            System.arraycopy(USER_R3_PADDING, 0, result, 16, 16);
            return result;
        }
        catch (Exception e) {
            throw new COSSecurityException(e);
        }
    }

    public int getRevision() {
        return 3;
    }
}

