/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.crypt;

import de.intarsys.pdf.cos.COSBoolean;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObjectKey;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.crypt.AESCryptHandler;
import de.intarsys.pdf.crypt.ArcFourCryptHandler;
import de.intarsys.pdf.crypt.COSEncryption;
import de.intarsys.pdf.crypt.COSSecurityException;
import de.intarsys.pdf.crypt.ICryptHandler;
import de.intarsys.pdf.crypt.IdentityCryptHandler;
import de.intarsys.pdf.crypt.StandardCryptHandler;
import de.intarsys.pdf.crypt.SystemSecurityHandler;
import de.intarsys.pdf.filter.Filter;
import java.util.HashMap;
import java.util.Map;

public class SystemSecurityHandlerV4
extends SystemSecurityHandler {
    public static final COSName CN_AESV2 = COSName.constant("AESV2");
    public static final COSName CN_CryptFilter = COSName.constant("CryptFilter");
    public static final COSName CN_None = COSName.constant("None");
    public static final COSName CN_V2 = COSName.constant("V2");
    public static final COSName DK_CFM = COSName.constant("CFM");
    public static final COSName DK_NAME = COSName.constant("Name");
    public static final COSName DK_TYPE = COSName.constant("Type");
    private Map<COSName, ICryptHandler> cryptHandlers = new HashMap<COSName, ICryptHandler>();

    protected SystemSecurityHandlerV4(COSDictionary dict) {
        super(dict);
    }

    public void cosAddCryptFilter(COSName name, COSDictionary cryptFilterDict) {
        COSDictionary encryptDict = this.cosGetEncryption();
        COSDictionary cryptFilters = encryptDict.get(COSEncryption.DK_CF).asDictionary();
        if (cryptFilters == null) {
            cryptFilters = COSDictionary.create();
            encryptDict.put(COSEncryption.DK_CF, cryptFilters);
        }
        cryptFilters.put(name, cryptFilterDict);
    }

    public COSDictionary cosGetCryptFilters() {
        COSDictionary encryptDict = this.cosGetEncryption();
        return encryptDict.get(COSEncryption.DK_CF).asDictionary();
    }

    public void cosRemoveCryptFilter(COSName name) {
        COSDictionary encryptDict = this.cosGetEncryption();
        COSDictionary cryptFilters = encryptDict.get(COSEncryption.DK_CF).asDictionary();
        if (cryptFilters == null) {
            return;
        }
        cryptFilters.remove(name);
    }

    protected COSDictionary createCryptFilterAES() {
        COSDictionary cryptFilterDict = COSDictionary.create();
        cryptFilterDict.put(DK_TYPE, CN_CryptFilter);
        cryptFilterDict.put(DK_CFM, CN_AESV2);
        cryptFilterDict.put(COSEncryption.DK_Length, COSInteger.create(128));
        return cryptFilterDict;
    }

    protected COSDictionary createCryptFilterArcFour() {
        COSDictionary cryptFilterDict = COSDictionary.create();
        cryptFilterDict.put(DK_TYPE, CN_CryptFilter);
        cryptFilterDict.put(DK_CFM, CN_V2);
        cryptFilterDict.put(COSEncryption.DK_Length, COSInteger.create(128));
        return cryptFilterDict;
    }

    protected COSDictionary createCryptFilterNone() {
        COSDictionary cryptFilterDict = COSDictionary.create();
        cryptFilterDict.put(DK_TYPE, CN_CryptFilter);
        cryptFilterDict.put(DK_CFM, CN_None);
        cryptFilterDict.put(COSEncryption.DK_Length, COSInteger.create(128));
        return cryptFilterDict;
    }

    protected ICryptHandler createCryptHandler(COSName name) throws COSSecurityException {
        if (COSEncryption.CN_IDENTITY.equals(name)) {
            return new IdentityCryptHandler();
        }
        COSDictionary dict = this.getEncryption().getCryptFilterDict(name);
        if (dict == null) {
            return new IdentityCryptHandler();
        }
        COSName method = dict.get(DK_CFM).asName();
        if (CN_V2.equals(method)) {
            ArcFourCryptHandler result = new ArcFourCryptHandler();
            ((StandardCryptHandler)result).initialize(this.getSecurityHandler().getCryptKey());
            return result;
        }
        if (CN_AESV2.equals(method)) {
            AESCryptHandler result = new AESCryptHandler();
            ((StandardCryptHandler)result).initialize(this.getSecurityHandler().getCryptKey());
            return result;
        }
        return this.getSecurityHandler();
    }

    public byte[] decryptFile(COSObjectKey key, COSDictionary dict, byte[] bytes) throws COSSecurityException {
        COSName name = this.getEncryption().getCryptFilterNameFile();
        ICryptHandler handler = this.getCryptHandler(name);
        byte[] result = handler.decrypt(key, bytes);
        return result;
    }

    public byte[] decryptStream(COSObjectKey key, COSDictionary dict, byte[] bytes) throws COSSecurityException {
        COSName name = COSEncryption.CN_IDENTITY;
        if (COSStream.hasFilter(dict, Filter.CN_Filter_Crypt)) {
            COSName paramName;
            COSDictionary decodeParams = COSStream.getDecodeParams(dict, Filter.CN_Filter_Crypt);
            if (decodeParams != null && (paramName = decodeParams.get(DK_NAME).asName()) != null) {
                name = paramName;
            }
        } else {
            name = this.getEncryption().getCryptFilterNameString();
        }
        ICryptHandler handler = this.getCryptHandler(name);
        byte[] result = handler.decrypt(key, bytes);
        return result;
    }

    public byte[] decryptString(COSObjectKey key, byte[] bytes) throws COSSecurityException {
        COSName name = this.getEncryption().getCryptFilterNameString();
        ICryptHandler handler = this.getCryptHandler(name);
        return handler.decrypt(key, bytes);
    }

    public byte[] encryptFile(COSObjectKey key, COSDictionary dict, byte[] bytes) throws COSSecurityException {
        COSName name = this.getEncryption().getCryptFilterNameFile();
        ICryptHandler handler = this.getCryptHandler(name);
        byte[] result = handler.encrypt(key, bytes);
        return result;
    }

    public byte[] encryptStream(COSObjectKey key, COSDictionary dict, byte[] bytes) throws COSSecurityException {
        if (!this.isEnabled()) {
            return bytes;
        }
        COSName name = COSEncryption.CN_IDENTITY;
        if (COSStream.hasFilter(dict, Filter.CN_Filter_Crypt)) {
            COSName paramName;
            COSDictionary decodeParams = COSStream.getDecodeParams(dict, Filter.CN_Filter_Crypt);
            if (decodeParams != null && (paramName = decodeParams.get(DK_NAME).asName()) != null) {
                name = paramName;
            }
        } else {
            name = this.getEncryption().getCryptFilterNameString();
        }
        ICryptHandler handler = this.getCryptHandler(name);
        byte[] result = handler.encrypt(key, bytes);
        return result;
    }

    public byte[] encryptString(COSObjectKey key, byte[] bytes) throws COSSecurityException {
        if (!this.isEnabled()) {
            return bytes;
        }
        COSName name = this.getEncryption().getCryptFilterNameString();
        ICryptHandler handler = this.getCryptHandler(name);
        return handler.encrypt(key, bytes);
    }

    public ICryptHandler getCryptHandler(COSName name) throws COSSecurityException {
        ICryptHandler cryptHandler = this.cryptHandlers.get(name);
        if (cryptHandler == null) {
            cryptHandler = this.createCryptHandler(name);
            this.cryptHandlers.put(name, cryptHandler);
        }
        return cryptHandler;
    }

    public int getLength() {
        return 128;
    }

    public int getVersion() {
        return 4;
    }

    protected void initializeFromScratch() {
        super.initializeFromScratch();
        COSEncryption encryption = this.getEncryption();
        encryption.setFieldInt(COSEncryption.DK_Length, 128);
        COSName standardFilterName = COSName.constant("StdCF");
        this.setEncryptionMethodAES(standardFilterName);
        this.setEncryptionFilterStream(standardFilterName);
        this.setEncryptionFilterString(standardFilterName);
        this.setEncryptMetadata(true);
    }

    public void setEncryptionFilterStream(COSName name) {
        COSDictionary encryptDict = this.cosGetEncryption();
        encryptDict.put(COSEncryption.DK_StmF, name);
    }

    public void setEncryptionFilterString(COSName name) {
        COSDictionary encryptDict = this.cosGetEncryption();
        encryptDict.put(COSEncryption.DK_StrF, name);
    }

    public void setEncryptionMethodAES(COSName filterName) {
        this.cosAddCryptFilter(filterName, this.createCryptFilterAES());
    }

    public void setEncryptionMethodArcFour(COSName filterName) {
        this.cosAddCryptFilter(filterName, this.createCryptFilterArcFour());
    }

    public void setEncryptionMethodNone(COSName filterName) {
        this.cosAddCryptFilter(filterName, this.createCryptFilterNone());
    }

    public void setEncryptMetadata(boolean value) {
        COSDictionary encryptDict = this.cosGetEncryption();
        encryptDict.put(COSEncryption.DK_EncryptMetadata, COSBoolean.create(value));
    }
}

