/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.adapter.AdapterTools;
import de.intarsys.tools.adapter.IAdapterSupport;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DelegatingLocator
implements ILocator,
IAdapterSupport {
    protected ILocator delegate;

    public DelegatingLocator(ILocator delegate) {
        this.delegate = delegate;
    }

    @Override
    public void delete() throws IOException {
        this.getDelegate().delete();
    }

    @Override
    public boolean exists() {
        try {
            return this.getDelegate().exists();
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        try {
            return AdapterTools.getAdapter(this.getDelegate(), clazz);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public ILocator getChild(String name) {
        try {
            return this.getDelegate().getChild(name);
        }
        catch (IOException e) {
            return null;
        }
    }

    public ILocator getDelegate() throws IOException {
        return this.delegate;
    }

    @Override
    public String getFullName() {
        try {
            return this.getDelegate().getFullName();
        }
        catch (IOException e) {
            return "";
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.getDelegate().getInputStream();
    }

    @Override
    public long getLength() throws IOException {
        return this.getDelegate().getLength();
    }

    @Override
    public String getLocalName() {
        try {
            return this.getDelegate().getLocalName();
        }
        catch (IOException e) {
            return "";
        }
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.getDelegate().getOutputStream();
    }

    @Override
    public ILocator getParent() {
        try {
            return this.getDelegate().getParent();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public IRandomAccess getRandomAccess() throws IOException {
        return this.getDelegate().getRandomAccess();
    }

    @Override
    public Reader getReader() throws IOException {
        return this.getDelegate().getReader();
    }

    @Override
    public Reader getReader(String encoding) throws IOException {
        return this.getDelegate().getReader(encoding);
    }

    @Override
    public String getType() {
        try {
            return this.getDelegate().getType();
        }
        catch (IOException e) {
            return "";
        }
    }

    @Override
    public String getTypedName() {
        try {
            return this.getDelegate().getTypedName();
        }
        catch (IOException e) {
            return "";
        }
    }

    @Override
    public Writer getWriter() throws IOException {
        return this.getDelegate().getWriter();
    }

    @Override
    public Writer getWriter(String encoding) throws IOException {
        return this.getDelegate().getWriter(encoding);
    }

    @Override
    public boolean isDirectory() {
        try {
            return this.getDelegate().isDirectory();
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean isOutOfSynch() {
        try {
            return this.getDelegate().isOutOfSynch();
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean isReadOnly() {
        try {
            return this.getDelegate().isReadOnly();
        }
        catch (IOException e) {
            return true;
        }
    }

    @Override
    public ILocator[] listLocators(ILocatorNameFilter filter) throws IOException {
        return this.getDelegate().listLocators(filter);
    }

    @Override
    public void rename(String newName) throws IOException {
        this.getDelegate().rename(newName);
    }

    @Override
    public void setReadOnly() {
        try {
            this.getDelegate().setReadOnly();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void synch() {
        try {
            this.getDelegate().synch();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public URL toURL() {
        try {
            return this.getDelegate().toURL();
        }
        catch (IOException e) {
            return null;
        }
    }
}

